/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import java.io.Serializable;
import org.apache.jackrabbit.spi.QPropertyDefinition;

class PropDefId
implements Serializable {
    static final long serialVersionUID = 3675238890036653593L;
    private final int id;

    public PropDefId(QPropertyDefinition def) {
        if (def == null) {
            throw new IllegalArgumentException("QPropertyDefinition argument can not be null");
        }
        StringBuffer sb = new StringBuffer();
        sb.append(def.getDeclaringNodeType().toString());
        sb.append('/');
        if (def.definesResidual()) {
            sb.append('*');
        } else {
            sb.append(def.getName().toString());
        }
        sb.append('/');
        sb.append(def.getRequiredType());
        sb.append('/');
        sb.append(def.isMultiple() ? 1 : 0);
        this.id = sb.toString().hashCode();
    }

    private PropDefId(int id) {
        this.id = id;
    }

    public static PropDefId valueOf(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("invalid PropDefId literal");
        }
        return new PropDefId(Integer.parseInt(s));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PropDefId) {
            PropDefId other = (PropDefId)obj;
            return this.id == other.id;
        }
        return false;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public int hashCode() {
        return this.id;
    }
}

