/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query;

import java.text.NumberFormat;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.ExecutableQuery;
import org.apache.jackrabbit.core.query.QueryHandler;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
extends AbstractQueryImpl {
    private static final Logger log = LoggerFactory.getLogger(QueryImpl.class);
    protected SessionImpl session;
    protected String statement;
    protected String language;
    protected ExecutableQuery query;
    protected Node node;
    protected QueryHandler handler;
    private boolean initialized = false;
    private long limit = -1L;
    private long offset;

    public void init(SessionImpl session, ItemManager itemMgr, QueryHandler handler, String statement, String language, Node node) throws InvalidQueryException {
        this.checkNotInitialized();
        this.session = session;
        this.statement = statement;
        this.language = language;
        this.handler = handler;
        this.node = node;
        this.query = handler.createExecutableQuery(session, itemMgr, statement, language);
        this.setInitialized();
    }

    public QueryResult execute() throws RepositoryException {
        this.checkInitialized();
        long time = System.currentTimeMillis();
        QueryResult result = this.query.execute(this.offset, this.limit);
        if (log.isDebugEnabled()) {
            time = System.currentTimeMillis() - time;
            NumberFormat format = NumberFormat.getNumberInstance();
            format.setMinimumFractionDigits(2);
            format.setMaximumFractionDigits(2);
            String seconds = format.format((double)time / 1000.0);
            log.debug("executed in " + seconds + " s. (" + this.statement + ")");
        }
        return result;
    }

    public String getStatement() {
        this.checkInitialized();
        return this.statement;
    }

    public String getLanguage() {
        this.checkInitialized();
        return this.language;
    }

    public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        if (this.node == null) {
            throw new ItemNotFoundException("not a persistent query");
        }
        return this.node.getPath();
    }

    public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkInitialized();
        try {
            Path p = this.session.getQPath(absPath).getNormalizedPath();
            if (!p.isAbsolute()) {
                throw new RepositoryException(absPath + " is not an absolute path");
            }
            String relPath = this.session.getJCRPath(p).substring(1);
            Node queryNode = this.session.getRootNode().addNode(relPath, this.session.getJCRName(NameConstants.NT_QUERY));
            queryNode.setProperty(this.session.getJCRName(NameConstants.JCR_LANGUAGE), this.language);
            queryNode.setProperty(this.session.getJCRName(NameConstants.JCR_STATEMENT), this.statement);
            this.node = queryNode;
            return this.node;
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public String[] getBindVariableNames() throws RepositoryException {
        Name[] names = this.query.getBindVariableNames();
        String[] strNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            strNames[i] = this.session.getJCRName(names[i]);
        }
        return strNames;
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        this.checkInitialized();
        try {
            this.query.bindValue(this.session.getQName(varName), value);
        }
        catch (NameException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    public void setLimit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("limit must not be negativ");
        }
        this.limit = limit;
    }

    public void setOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset must not be negativ");
        }
        this.offset = offset;
    }

    protected void setInitialized() {
        this.initialized = true;
    }

    protected void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }
}

