/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.core.query.lucene.AbstractWeight;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.Transformable;
import org.apache.jackrabbit.core.query.lucene.WildcardTermEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WildcardQuery
extends Query
implements Transformable {
    private static final Logger log = LoggerFactory.getLogger(WildcardQuery.class);
    private final String field;
    private final String propName;
    private final String pattern;
    private int transform = 0;
    private Query multiTermQuery;

    public WildcardQuery(String field, String propName, String pattern, int transform) {
        this.field = field.intern();
        this.propName = propName;
        this.pattern = pattern;
        this.transform = transform;
    }

    public WildcardQuery(String field, String propName, String pattern) {
        this(field, propName, pattern, 0);
    }

    public void setTransformation(int transformation) {
        this.transform = transformation;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        MultiTermQuery stdWildcardQuery = new MultiTermQuery(new Term(this.field, this.pattern)){

            protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
                return new WildcardTermEnum(reader, WildcardQuery.this.field, WildcardQuery.this.propName, WildcardQuery.this.pattern, WildcardQuery.this.transform);
            }
        };
        try {
            this.multiTermQuery = stdWildcardQuery.rewrite(reader);
            return this.multiTermQuery;
        }
        catch (BooleanQuery.TooManyClauses e) {
            log.debug("Too many terms to enumerate, using custom WildcardQuery.");
            return this;
        }
    }

    protected Weight createWeight(Searcher searcher) {
        return new WildcardQueryWeight(searcher);
    }

    public String toString(String field) {
        return this.propName + ":" + this.pattern;
    }

    public void extractTerms(Set terms) {
        if (this.multiTermQuery != null) {
            this.multiTermQuery.extractTerms(terms);
        }
    }

    private final class WildcardQueryScorer
    extends Scorer {
        private final IndexReader reader;
        private final BitSet hits;
        private boolean hitsCalculated;
        private int nextDoc;
        private final String cacheKey;
        private final Map<String, BitSet> resultMap;

        WildcardQueryScorer(Similarity similarity, IndexReader reader) {
            super(similarity);
            this.hitsCalculated = false;
            this.nextDoc = -1;
            this.reader = reader;
            this.cacheKey = WildcardQuery.this.field + '\uffff' + WildcardQuery.this.propName + '\uffff' + WildcardQuery.this.transform + '\uffff' + WildcardQuery.this.pattern;
            PerQueryCache cache = PerQueryCache.getInstance();
            HashMap m = (HashMap)cache.get(WildcardQueryScorer.class, reader);
            if (m == null) {
                m = new HashMap();
                cache.put(WildcardQueryScorer.class, reader, m);
            }
            this.resultMap = m;
            BitSet result = this.resultMap.get(this.cacheKey);
            if (result == null) {
                result = new BitSet(reader.maxDoc());
            } else {
                this.hitsCalculated = true;
            }
            this.hits = result;
        }

        public boolean next() throws IOException {
            this.calculateHits();
            this.nextDoc = this.hits.nextSetBit(this.nextDoc + 1);
            return this.nextDoc > -1;
        }

        public int doc() {
            return this.nextDoc;
        }

        public float score() {
            return 1.0f;
        }

        public boolean skipTo(int target) throws IOException {
            this.calculateHits();
            this.nextDoc = this.hits.nextSetBit(target);
            return this.nextDoc > -1;
        }

        public Explanation explain(int doc) {
            return new Explanation();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculateHits() throws IOException {
            if (this.hitsCalculated) {
                return;
            }
            WildcardTermEnum terms = new WildcardTermEnum(this.reader, WildcardQuery.this.field, WildcardQuery.this.propName, WildcardQuery.this.pattern, WildcardQuery.this.transform);
            try {
                TermDocs docs = this.reader.termDocs();
                try {
                    while (terms.term() != null) {
                        docs.seek((TermEnum)terms);
                        while (docs.next()) {
                            this.hits.set(docs.doc());
                        }
                        if (terms.next()) continue;
                        break;
                    }
                }
                finally {
                    docs.close();
                }
            }
            finally {
                terms.close();
            }
            this.hitsCalculated = true;
            this.resultMap.put(this.cacheKey, this.hits);
        }
    }

    private class WildcardQueryWeight
    extends AbstractWeight {
        public WildcardQueryWeight(Searcher searcher) {
            super(searcher);
        }

        protected Scorer createScorer(IndexReader reader) {
            return new WildcardQueryScorer(this.searcher.getSimilarity(), reader);
        }

        public Query getQuery() {
            return WildcardQuery.this;
        }

        public float getValue() {
            return 1.0f;
        }

        public float sumOfSquaredWeights() throws IOException {
            return 1.0f;
        }

        public void normalize(float norm) {
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            return new Explanation();
        }
    }
}

