/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.net.URLDecoder;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.query.InvalidQueryException;
import org.apache.jackrabbit.commons.query.qom.Operator;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.constraint.AndConstraint;
import org.apache.jackrabbit.core.query.lucene.constraint.ChildNodeConstraint;
import org.apache.jackrabbit.core.query.lucene.constraint.ComparisonConstraint;
import org.apache.jackrabbit.core.query.lucene.constraint.Constraint;
import org.apache.jackrabbit.core.query.lucene.constraint.DescendantNodeConstraint;
import org.apache.jackrabbit.core.query.lucene.constraint.DynamicOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.FullTextConstraint;
import org.apache.jackrabbit.core.query.lucene.constraint.FullTextSearchScoreOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.LengthOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.LikeConstraint;
import org.apache.jackrabbit.core.query.lucene.constraint.LowerCaseOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.NodeLocalNameOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.NodeNameOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.NotConstraint;
import org.apache.jackrabbit.core.query.lucene.constraint.OrConstraint;
import org.apache.jackrabbit.core.query.lucene.constraint.PropertyExistenceConstraint;
import org.apache.jackrabbit.core.query.lucene.constraint.PropertyValueOperand;
import org.apache.jackrabbit.core.query.lucene.constraint.SameNodeConstraint;
import org.apache.jackrabbit.core.query.lucene.constraint.UpperCaseOperand;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.qom.AndImpl;
import org.apache.jackrabbit.spi.commons.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ChildNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ComparisonImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ConstraintImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DefaultQOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.DescendantNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DynamicOperandImpl;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchImpl;
import org.apache.jackrabbit.spi.commons.query.qom.FullTextSearchScoreImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LengthImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LiteralImpl;
import org.apache.jackrabbit.spi.commons.query.qom.LowerCaseImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NodeLocalNameImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NodeNameImpl;
import org.apache.jackrabbit.spi.commons.query.qom.NotImpl;
import org.apache.jackrabbit.spi.commons.query.qom.OrImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyExistenceImpl;
import org.apache.jackrabbit.spi.commons.query.qom.PropertyValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.SameNodeImpl;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;
import org.apache.jackrabbit.spi.commons.query.qom.StaticOperandImpl;
import org.apache.jackrabbit.spi.commons.query.qom.UpperCaseImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintBuilder {
    public static Constraint create(ConstraintImpl constraint, Map<Name, Value> bindVariableValues, SelectorImpl[] selectors, LuceneQueryFactory factory, ValueFactory vf) throws RepositoryException {
        try {
            return (Constraint)constraint.accept((QOMTreeVisitor)new Visitor(bindVariableValues, selectors, factory, vf), null);
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Visitor
    extends DefaultQOMTreeVisitor {
        private final Map<Name, Value> bindVariableValues;
        private final SelectorImpl[] selectors;
        private final LuceneQueryFactory factory;
        private final ValueFactory vf;

        Visitor(Map<Name, Value> bindVariableValues, SelectorImpl[] selectors, LuceneQueryFactory factory, ValueFactory vf) {
            this.bindVariableValues = bindVariableValues;
            this.selectors = selectors;
            this.factory = factory;
            this.vf = vf;
        }

        public Object visit(AndImpl node, Object data) throws Exception {
            ConstraintImpl left = (ConstraintImpl)node.getConstraint1();
            ConstraintImpl right = (ConstraintImpl)node.getConstraint2();
            return new AndConstraint((Constraint)left.accept((QOMTreeVisitor)this, null), (Constraint)right.accept((QOMTreeVisitor)this, null));
        }

        public Object visit(BindVariableValueImpl node, Object data) throws Exception {
            return this.bindVariableValues.get(node.getBindVariableQName());
        }

        public Object visit(ChildNodeImpl node, Object data) throws Exception {
            return new ChildNodeConstraint(node, this.getSelector(node.getSelectorQName()));
        }

        public Object visit(ComparisonImpl node, Object data) throws Exception {
            DynamicOperandImpl op1 = (DynamicOperandImpl)node.getOperand1();
            Operator operator = node.getOperatorInstance();
            StaticOperandImpl op2 = (StaticOperandImpl)node.getOperand2();
            Value staticValue = (Value)op2.accept((QOMTreeVisitor)this, null);
            DynamicOperand dynOp = (DynamicOperand)op1.accept((QOMTreeVisitor)this, (Object)staticValue);
            SelectorImpl selector = this.getSelector(op1.getSelectorQName());
            if (operator == Operator.LIKE) {
                return new LikeConstraint(dynOp, staticValue, selector);
            }
            return new ComparisonConstraint(dynOp, operator, staticValue, selector);
        }

        public Object visit(DescendantNodeImpl node, Object data) throws Exception {
            return new DescendantNodeConstraint(node, this.getSelector(node.getSelectorQName()));
        }

        public Object visit(FullTextSearchImpl node, Object data) throws Exception {
            return new FullTextConstraint(node, this.getSelector(node.getSelectorQName()), this.factory);
        }

        public Object visit(FullTextSearchScoreImpl node, Object data) throws Exception {
            return new FullTextSearchScoreOperand();
        }

        public Object visit(LengthImpl node, Object data) throws Exception {
            Value staticValue = (Value)data;
            try {
                staticValue.getLong();
            }
            catch (ValueFormatException e) {
                throw new InvalidQueryException("Static value " + staticValue.getString() + " cannot be converted to a Long");
            }
            PropertyValueImpl propValue = (PropertyValueImpl)node.getPropertyValue();
            return new LengthOperand((PropertyValueOperand)propValue.accept((QOMTreeVisitor)this, null));
        }

        public Object visit(LiteralImpl node, Object data) throws Exception {
            return node.getLiteralValue();
        }

        public Object visit(LowerCaseImpl node, Object data) throws Exception {
            DynamicOperandImpl operand = (DynamicOperandImpl)node.getOperand();
            return new LowerCaseOperand((DynamicOperand)operand.accept((QOMTreeVisitor)this, data));
        }

        public Object visit(NodeLocalNameImpl node, Object data) throws Exception {
            return new NodeLocalNameOperand();
        }

        public Object visit(NodeNameImpl node, Object data) throws Exception {
            Value staticValue = (Value)data;
            switch (staticValue.getType()) {
                case 1: 
                case 8: 
                case 11: {
                    try {
                        String s = staticValue.getString();
                        if (staticValue.getType() == 11) {
                            if (s.startsWith("./")) {
                                s = s.substring(2);
                            }
                            s = URLDecoder.decode(s, "UTF-8");
                        }
                        this.vf.createValue(s, 7);
                        break;
                    }
                    catch (ValueFormatException e) {
                        throw new InvalidQueryException("Value " + staticValue.getString() + " cannot be converted into NAME");
                    }
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 12: {
                    throw new InvalidQueryException(staticValue.getString() + " cannot be converted into a NAME value");
                }
            }
            return new NodeNameOperand();
        }

        public Object visit(NotImpl node, Object data) throws Exception {
            ConstraintImpl c = (ConstraintImpl)node.getConstraint();
            return new NotConstraint((Constraint)c.accept((QOMTreeVisitor)this, null));
        }

        public Object visit(OrImpl node, Object data) throws Exception {
            ConstraintImpl left = (ConstraintImpl)node.getConstraint1();
            ConstraintImpl right = (ConstraintImpl)node.getConstraint2();
            return new OrConstraint((Constraint)left.accept((QOMTreeVisitor)this, null), (Constraint)right.accept((QOMTreeVisitor)this, null));
        }

        public Object visit(PropertyExistenceImpl node, Object data) throws Exception {
            return new PropertyExistenceConstraint(node, this.getSelector(node.getSelectorQName()), this.factory);
        }

        public Object visit(PropertyValueImpl node, Object data) throws Exception {
            return new PropertyValueOperand(node);
        }

        public Object visit(SameNodeImpl node, Object data) throws Exception {
            return new SameNodeConstraint(node, this.getSelector(node.getSelectorQName()));
        }

        public Object visit(UpperCaseImpl node, Object data) throws Exception {
            DynamicOperandImpl operand = (DynamicOperandImpl)node.getOperand();
            return new UpperCaseOperand((DynamicOperand)operand.accept((QOMTreeVisitor)this, data));
        }

        private SelectorImpl getSelector(Name name) {
            for (SelectorImpl selector : this.selectors) {
                if (!selector.getSelectorQName().equals(name)) continue;
                return selector;
            }
            return null;
        }
    }
}

