/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pacl.Reflection;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;

public class ReflectChecker
extends BaseChecker {
    private static Log _log = LogFactoryUtil.getLog(ReflectChecker.class);
    private boolean _suppressAccessChecks;

    @Override
    public void afterPropertiesSet() {
        this.initSuppressAccessChecks();
    }

    @Override
    public AuthorizationProperty generateAuthorizationProperty(Object ... arguments) {
        if (arguments == null || arguments.length != 1 || !(arguments[0] instanceof Permission)) {
            return null;
        }
        Permission permission = (Permission)arguments[0];
        String name = permission.getName();
        String key = null;
        String value = null;
        if (!name.startsWith("suppressAccessChecks")) {
            return null;
        }
        key = "security-manager-suppress-access-checks";
        value = Boolean.TRUE.toString();
        AuthorizationProperty authorizationProperty = new AuthorizationProperty();
        authorizationProperty.setKey(key);
        authorizationProperty.setValue(value);
        return authorizationProperty;
    }

    @Override
    public boolean implies(Permission permission) {
        String name = permission.getName();
        if (name.startsWith("suppressAccessChecks")) {
            if (!this.hasSuppressAccessChecks(permission)) {
                this.logSecurityException(_log, "Attempted to suppess access checks");
                return false;
            }
        } else {
            int stackIndex = Reflection.getStackIndex(10, 9);
            Class<?> callerClass = Reflection.getCallerClass(stackIndex);
            if (this.isTrustedCaller(callerClass, permission)) {
                return true;
            }
            this.logSecurityException(_log, "Attempted to reflect");
            return false;
        }
        return true;
    }

    protected boolean hasSuppressAccessChecks(Permission permission) {
        if (this._suppressAccessChecks) {
            return true;
        }
        int stackIndex = Reflection.getStackIndex(11, 10);
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        if (this.isTrustedCaller(callerClass, permission)) {
            return true;
        }
        this.logSecurityException(_log, "Attempted to reflect");
        return false;
    }

    protected void initSuppressAccessChecks() {
        this._suppressAccessChecks = this.getPropertyBoolean("security-manager-suppress-access-checks");
    }
}

