/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.jndi;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.security.lang.DoPrivilegedFactory;
import com.liferay.portal.security.pacl.PACLPolicy;
import com.liferay.portal.security.pacl.PACLUtil;
import com.liferay.portal.security.pacl.jndi.PACLContext;
import com.liferay.portal.security.pacl.jndi.SchemeAwareContextWrapper;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;

public class PACLInitialContextFactory
implements InitialContextFactory {
    private Hashtable<?, ?> _environment;
    private InitialContextFactoryBuilder _initialContextFactoryBuilder;
    private Log _log = LogFactoryUtil.getLog((String)PACLInitialContextFactory.class.getName());

    public PACLInitialContextFactory(InitialContextFactoryBuilder initialContextFactoryBuilder, Hashtable<?, ?> environment) {
        this._initialContextFactoryBuilder = initialContextFactoryBuilder;
        if (environment != null) {
            this._environment = new Hashtable(environment);
        }
    }

    @Override
    public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
        try {
            return this.doGetInitialContext(environment);
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
    }

    protected Context doGetInitialContext(Hashtable<?, ?> environment) throws Exception {
        InitialContextFactory initialContextFactory = null;
        if (this._initialContextFactoryBuilder != null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Use " + this._initialContextFactoryBuilder.getClass() + " to instantiate initial context factory"));
            }
            initialContextFactory = this._initialContextFactoryBuilder.createInitialContextFactory(environment);
        } else {
            if (environment == null) {
                environment = this._environment;
            }
            String initialContextFactoryClassName = null;
            if (environment != null) {
                initialContextFactoryClassName = (String)environment.get("java.naming.factory.initial");
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Environment initial context factory " + initialContextFactoryClassName));
                }
            }
            if (initialContextFactoryClassName == null) {
                initialContextFactoryClassName = System.getProperty("java.naming.factory.initial");
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("System initial context factory " + initialContextFactoryClassName));
                }
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Instantiating " + initialContextFactoryClassName));
            }
            initialContextFactory = (InitialContextFactory)InstanceFactory.newInstance((String)initialContextFactoryClassName);
        }
        Context context = initialContextFactory.getInitialContext(environment);
        Class<?> clazz = context.getClass();
        Class<?>[] interfaces = clazz.getInterfaces();
        boolean ldapContext = false;
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaceClass = classArray[n2];
            String interfaceClassName = interfaceClass.getName();
            if (interfaceClassName.equals(LdapContext.class.getName())) {
                ldapContext = true;
            }
            ++n2;
        }
        if (context instanceof LdapContext || ldapContext) {
            return context;
        }
        context = new SchemeAwareContextWrapper(context);
        PACLPolicy paclPolicy = PACLUtil.getPACLPolicy();
        if (paclPolicy == null) {
            return context;
        }
        context = (Context)DoPrivilegedFactory.wrap((Object)context);
        paclPolicy = (PACLPolicy)DoPrivilegedFactory.wrap((Object)paclPolicy);
        return new PACLContext(context, paclPolicy);
    }
}

