/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Core;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarClassLoader {
    private Vector classVector = new Vector();
    private String jarFileName;
    private String packageName;
    private static String WARNING = "Warning : No jar file found. Packet unmarshalling won't be possible. Please verify your classpath";

    public JarClassLoader(String jarFileName, String packageName) {
        this.jarFileName = jarFileName;
        this.packageName = packageName;
        this.cacheClasses();
    }

    private void cacheClasses() {
        try {
            JarFile jarFile = new JarFile(this.jarFileName);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!this.match(this.normalize(entry.getName()), this.packageName)) continue;
                this.classVector.add(this.normalize(entry.getName()));
            }
        }
        catch (IOException IOE) {
            System.out.println(WARNING);
        }
    }

    public Class loadClass(int commandId, int subCommmandId) {
        Class<?> ret = null;
        String endString = "__" + commandId + "_" + subCommmandId + ".class";
        for (int i = 0; i < this.classVector.size(); ++i) {
            if (!((String)this.classVector.elementAt(i)).endsWith(endString)) continue;
            try {
                ret = Class.forName(this.stripClassName((String)this.classVector.elementAt(i)));
                continue;
            }
            catch (ClassNotFoundException CNFE) {
                System.out.println(CNFE.getMessage());
            }
        }
        return ret;
    }

    private String stripClassName(String className) {
        return className.substring(0, className.length() - 6);
    }

    private String normalize(String className) {
        return className.replace('/', '.');
    }

    private boolean match(String className, String packageName) {
        return className.startsWith(packageName) && className.endsWith(".class");
    }

    public void setPath(String fileName) {
        this.jarFileName = fileName;
        this.classVector.removeAllElements();
        this.cacheClasses();
    }
}

