/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Core;

import JOscarLib.Core.OscarClient;
import JOscarLib.Core.OscarPacketAnalyser;
import JOscarLib.Flap;
import JOscarLib.Integration.Event.MessagingListener;
import JOscarLib.Integration.Event.StatusListener;
import JOscarLib.Request.Event.RequestListener;
import JOscarLib.Request.Request;
import JOscarLib.Request.RequestKeeper;
import JOscarLib.Setting.Tweaker;
import JOscarLib.Tlv;
import java.io.IOException;
import java.util.Observable;
import java.util.Vector;

public class OscarConnection
extends Observable {
    private Tlv cookie;
    private String userId;
    private String password;
    private boolean logged = false;
    private Tweaker tweaker;
    private OscarClient client;
    private OscarPacketAnalyser analyser;
    private RequestKeeper requestKeeper;
    private Vector messagingListeners;
    private Vector statusListeners;

    public OscarConnection(String host, int port, String userId, String password) {
        this(host, port, userId, password, new Tweaker());
    }

    public OscarConnection(String host, int port, String userId, String password, Tweaker tweaker) {
        this.userId = userId;
        this.password = password;
        this.tweaker = tweaker;
        this.analyser = new OscarPacketAnalyser(this);
        this.client = new OscarClient(host, port, this.analyser);
        this.requestKeeper = new RequestKeeper();
        this.messagingListeners = new Vector(0);
        this.statusListeners = new Vector(0);
        this.client.connectToServer();
    }

    public void addMessagingListener(MessagingListener listener) {
        this.messagingListeners.add(listener);
    }

    public boolean removeMessagingListener(MessagingListener listener) {
        return this.messagingListeners.remove(listener);
    }

    public void addStatusListener(StatusListener listener) {
        this.statusListeners.add(listener);
    }

    public boolean removeStatusListener(StatusListener listener) {
        return this.messagingListeners.remove(listener);
    }

    public void sendFlap(Flap flapPacket) {
        this.client.sendPacket(flapPacket.getByteArray());
    }

    public Request sendMonitoredFlap(Flap flapPacket, RequestListener listener) {
        Request request = null;
        if (flapPacket.hasSnac()) {
            int requestId = this.requestKeeper.nextAvailableRequestId();
            flapPacket.getSnac().setRequestId(requestId);
            request = new Request(flapPacket, listener);
            this.requestKeeper.addRequest(request);
        }
        this.sendFlap(flapPacket);
        return request;
    }

    public void close() throws IOException {
        this.client.disconnect();
        this.setLogged(false);
    }

    protected void setLogged(boolean status) {
        this.logged = status;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isLogged() {
        return this.logged;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public Tlv getCookie() {
        return this.cookie;
    }

    public void setCookie(Tlv cookie) {
        this.cookie = cookie;
    }

    public OscarClient getClient() {
        return this.client;
    }

    public void setClient(OscarClient client) {
        this.client = client;
    }

    public Tweaker getTweaker() {
        return this.tweaker;
    }

    public OscarPacketAnalyser getPacketAnalyser() {
        return this.analyser;
    }

    public Vector getMessagingListeners() {
        return this.messagingListeners;
    }

    public Vector getStatusListeners() {
        return this.statusListeners;
    }

    public RequestKeeper getRequestKeeper() {
        return this.requestKeeper;
    }
}

