/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Core;

import JOscarLib.Core.Exceptions.LoginException;
import JOscarLib.Core.JarClassLoader;
import JOscarLib.Core.OscarConnection;
import JOscarLib.Packet.Received.AuthorizationReply;
import JOscarLib.Packet.Received.ReceivedPacket;
import JOscarLib.Packet.Sent.AuthorizationRequest;
import JOscarLib.Packet.Sent.SignonCommand;
import JOscarLib.Tool.Dumper;
import JOscarLib.Tool.RulesFilter;
import com.liferay.portal.util.PropsUtil;

public class OscarPacketAnalyser {
    private OscarConnection connection;
    private JarClassLoader jarClassLoader;
    private RulesFilter rulesFilter;
    private int nbPacket = 0;
    private boolean debug = false;
    private boolean dump = false;

    public OscarPacketAnalyser(OscarConnection connection) {
        this.connection = connection;
        String jarFileName = PropsUtil.get((String)"icq.jar");
        this.jarClassLoader = new JarClassLoader(jarFileName, "JOscarLib.Packet.Received");
        this.rulesFilter = new RulesFilter();
    }

    protected void handlePacket(byte[] packet) {
        try {
            ++this.nbPacket;
            if (this.nbPacket == 1) {
                this.connection.sendFlap(new AuthorizationRequest(this.connection.getUserId(), this.connection.getPassword()));
            } else if (this.nbPacket == 2) {
                AuthorizationReply reply = new AuthorizationReply(packet);
                reply.execute(this.connection);
            } else if (this.nbPacket == 3) {
                this.connection.sendFlap(new SignonCommand(this.connection.getCookie()));
            } else {
                this.handleService(packet);
            }
        }
        catch (Exception E) {
            throw new LoginException("Problem due to : " + E.getMessage());
        }
    }

    protected void handleService(byte[] packet) throws Exception {
        Class loadedClass;
        ReceivedPacket receivedFlap = new ReceivedPacket(packet, true);
        int familyId = receivedFlap.getSnac().getFamilyId();
        int subTypeId = receivedFlap.getSnac().getSubTypeId();
        if (this.debug) {
            System.out.println("Received " + familyId + " - " + subTypeId);
        }
        if ((loadedClass = this.jarClassLoader.loadClass(familyId, subTypeId)) != null) {
            if (this.dump && this.rulesFilter.containsRule(familyId, subTypeId)) {
                System.out.println(Dumper.dump(packet, true));
            }
            Class[] constructorParam = new Class[]{packet.getClass()};
            Object[] param = new Object[]{packet};
            receivedFlap = (ReceivedPacket)loadedClass.getConstructor(constructorParam).newInstance(param);
            receivedFlap.execute(this.connection);
            receivedFlap.notifyEvent(this.connection);
            if (this.debug) {
                System.out.println("--> " + loadedClass.getName() + " loaded");
            }
        }
        receivedFlap.matchRequest(this.connection);
        if (familyId == 9 && subTypeId == 3) {
            this.connection.setLogged(true);
        }
    }

    public void setDebug(boolean state) {
        this.debug = state;
    }

    public void setDump(boolean state) {
        this.dump = state;
    }

    public boolean isDebugging() {
        return this.debug;
    }

    public boolean isDumping() {
        return this.dump;
    }

    public JarClassLoader getJarClassLoader() {
        return this.jarClassLoader;
    }

    public RulesFilter getRulesFilter() {
        return this.rulesFilter;
    }
}

