/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib;

import JOscarLib.DataContainer;
import JOscarLib.RawData;
import JOscarLib.Snac;
import JOscarLib.Tlv;

public class Flap
extends DataContainer {
    private static final int FLAP_HEADER_SIZE = 6;
    private static int SEQUENCE_NUMBER = 0;
    private RawData commandStart;
    private RawData channelId;
    private RawData sequenceNumber;
    private RawData dataFieldLength;
    private byte[] headerByteArray = new byte[6];
    private boolean hasSnac = false;

    public Flap() {
        this.commandStart = new RawData(42);
    }

    public Flap(int channelId) {
        this();
        this.channelId = new RawData(channelId, 1);
        this.sequenceNumber = new RawData(this.nextSequenceNumber(), 2);
    }

    public Flap(int channelId, Snac snac) {
        this(channelId);
        this.addSnac(snac);
    }

    public int nextSequenceNumber() {
        if (++SEQUENCE_NUMBER > 65535) {
            SEQUENCE_NUMBER = 0;
        }
        return SEQUENCE_NUMBER;
    }

    public int getChannelId() {
        return this.channelId.getValue();
    }

    public void setChannelId(int channelId) {
        this.channelId = new RawData(channelId, 1);
        this.headerModified = true;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber.getValue();
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = new RawData(sequenceNumber, 2);
        this.headerModified = true;
    }

    public boolean hasSnac() {
        return this.hasSnac;
    }

    public Snac getSnac() {
        return (Snac)this.elementAt(0);
    }

    public void addSnac(Snac snac) {
        this.addDataField(snac);
        this.hasSnac = true;
    }

    public void addTlvToFlap(Tlv tlv) {
        this.addDataField(tlv);
    }

    public void addRawDataToFlap(RawData rawData) {
        this.addDataField(rawData);
    }

    public byte[] getHeaderByteArray() {
        if (this.headerModified) {
            this.dataFieldLength = new RawData(this.getDataFieldByteArray().length, 2);
            int position = 0;
            System.arraycopy(this.commandStart.getByteArray(), 0, this.headerByteArray, position, this.commandStart.getByteArray().length);
            System.arraycopy(this.channelId.getByteArray(), 0, this.headerByteArray, position += this.commandStart.getByteArray().length, this.channelId.getByteArray().length);
            System.arraycopy(this.sequenceNumber.getByteArray(), 0, this.headerByteArray, position += this.channelId.getByteArray().length, this.sequenceNumber.getByteArray().length);
            System.arraycopy(this.dataFieldLength.getByteArray(), 0, this.headerByteArray, position += this.sequenceNumber.getByteArray().length, this.dataFieldLength.getByteArray().length);
            this.headerModified = false;
        }
        return this.headerByteArray;
    }
}

