/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Request;

import JOscarLib.Flap;
import JOscarLib.Request.Event.RequestListener;
import java.util.ArrayList;

public class Request {
    private Flap monitoredFlap;
    private ArrayList listeners;

    public Request(Flap packet, RequestListener listener) {
        this.monitoredFlap = packet;
        this.listeners = new ArrayList();
        this.listeners.add(listener);
    }

    public boolean containsListener(RequestListener listener) {
        return this.listeners.contains(listener);
    }

    public void addListener(RequestListener listener) {
        if (!this.containsListener(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(RequestListener listener) {
        if (this.containsListener(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void removeAllListener() {
        this.listeners.clear();
    }

    public int getRequestId() {
        return this.monitoredFlap.getSnac().getRequestId();
    }

    public Flap getMonitoredFlap() {
        return this.monitoredFlap;
    }

    public int getNbListeners() {
        return this.listeners.size();
    }

    public RequestListener getRequestListener(int index) throws IndexOutOfBoundsException {
        return (RequestListener)this.listeners.get(index);
    }
}

