/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

public class GeoMatchUtil {
    public static final float EARTH_RADIUS_MILES = 3956.0f;
    public static final float EARTH_RADIUS_KM = 6371.0f;
    public static final float LATITUDE_DEGREES_MIN = -90.0f;
    public static final float LATITUDE_DEGREES_MAX = 90.0f;
    public static final float LONGITUDE_DEGREES_MIN = -180.0f;
    public static final float LONGITUDE_DEGREES_MAX = 180.0f;

    public static float degreesToRadians(float degrees) {
        return (float)((double)degrees * (Math.PI / 180));
    }

    public static float getMilesRadiusCosine(float radiusInMiles) {
        float radiusCosine = (float)Math.cos(radiusInMiles / 3956.0f);
        return radiusCosine;
    }

    public static float getKMRadiusCosine(float radiusInKM) {
        float radiusCosine = (float)Math.cos(radiusInKM / 6371.0f);
        return radiusCosine;
    }

    public static float[] geoMatchCoordsFromDegrees(float latDegrees, float lonDegrees) {
        float[] geoMatchCoords = Float.isNaN(latDegrees) || Float.isNaN(lonDegrees) ? new float[]{Float.NaN, Float.NaN, Float.NaN} : GeoMatchUtil.geoMatchCoordsFromRadians((float)((double)latDegrees * (Math.PI / 180)), (float)((double)lonDegrees * (Math.PI / 180)));
        return geoMatchCoords;
    }

    public static float[] geoMatchCoordsFromRadians(float latRadians, float lonRadians) {
        float[] geoMatchCoords = Float.isNaN(latRadians) || Float.isNaN(lonRadians) ? new float[]{Float.NaN, Float.NaN, Float.NaN} : new float[]{GeoMatchUtil.geoMatchXCoordFromRadians(latRadians, lonRadians), GeoMatchUtil.geoMatchYCoordFromRadians(latRadians, lonRadians), GeoMatchUtil.geoMatchZCoordFromRadians(latRadians)};
        return geoMatchCoords;
    }

    public static float geoMatchXCoordFromDegrees(float latDegrees, float lonDegrees) {
        if (Float.isNaN(latDegrees) || Float.isNaN(lonDegrees)) {
            return Float.NaN;
        }
        return GeoMatchUtil.geoMatchXCoordFromRadians((float)((double)latDegrees * (Math.PI / 180)), (float)((double)lonDegrees * (Math.PI / 180)));
    }

    public static float geoMatchYCoordFromDegrees(float latDegrees, float lonDegrees) {
        if (Float.isNaN(latDegrees) || Float.isNaN(lonDegrees)) {
            return Float.NaN;
        }
        return GeoMatchUtil.geoMatchYCoordFromRadians((float)((double)latDegrees * (Math.PI / 180)), (float)((double)lonDegrees * (Math.PI / 180)));
    }

    public static float geoMatchZCoordFromDegrees(float latDegrees) {
        if (Float.isNaN(latDegrees)) {
            return Float.NaN;
        }
        return GeoMatchUtil.geoMatchZCoordFromRadians((float)((double)latDegrees * (Math.PI / 180)));
    }

    public static float geoMatchXCoordFromRadians(float latRadians, float lonRadians) {
        if (Float.isNaN(latRadians) || Float.isNaN(lonRadians)) {
            return Float.NaN;
        }
        return (float)(Math.cos(latRadians) * Math.cos(lonRadians));
    }

    public static float geoMatchYCoordFromRadians(float latRadians, float lonRadians) {
        if (Float.isNaN(latRadians) || Float.isNaN(lonRadians)) {
            return Float.NaN;
        }
        return (float)(Math.cos(latRadians) * Math.sin(lonRadians));
    }

    public static float geoMatchZCoordFromRadians(float latRadians) {
        if (Float.isNaN(latRadians)) {
            return Float.NaN;
        }
        return (float)Math.sin(latRadians);
    }

    public static float getMatchLatDegreesFromXYZCoords(float x, float y, float z) {
        return (float)Math.toDegrees(Math.asin(z));
    }

    public static float getMatchLonDegreesFromXYZCoords(float x, float y, float z) {
        float lon = (float)Math.toDegrees(Math.asin((double)y / Math.cos(Math.asin(z))));
        if (x < 0.0f && y > 0.0f) {
            return 180.0f - lon;
        }
        if (y < 0.0f && x < 0.0f) {
            return -180.0f - lon;
        }
        return lon;
    }
}

