/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.PriorityQueue;

public class SearchResultMerger<T> {
    private SearchResultMerger() {
    }

    public static <T> Iterator<T> mergeIterator(List<Iterator<T>> results, Comparator<T> comparator) {
        return new MergedIterator<T>(results, comparator);
    }

    public static <T> ArrayList<T> mergeResult(int offset, int count, List<Iterator<T>> results, Comparator<T> comparator) {
        Iterator<T> mergedIter = SearchResultMerger.mergeIterator(results, comparator);
        for (int c = 0; c < offset && mergedIter.hasNext(); ++c) {
            mergedIter.next();
        }
        ArrayList<T> mergedList = new ArrayList<T>();
        for (int c = 0; c < count && mergedIter.hasNext(); ++c) {
            mergedList.add(mergedIter.next());
        }
        return mergedList;
    }

    public static class MergedIterator<T>
    implements Iterator<T> {
        private final PriorityQueue _queue;

        public MergedIterator(final List<Iterator<T>> sources, final Comparator<T> comparator) {
            this._queue = new PriorityQueue(){
                {
                    this.initialize(sources.size());
                }

                protected boolean lessThan(Object o1, Object o2) {
                    Object v1 = ((IteratorCtx)o1)._curVal;
                    Object v2 = ((IteratorCtx)o2)._curVal;
                    return comparator.compare(v1, v2) < 0;
                }
            };
            for (Iterator<T> iterator : sources) {
                IteratorCtx ctx = new IteratorCtx(iterator);
                if (!ctx.fetch()) continue;
                this._queue.add((Object)ctx);
            }
        }

        @Override
        public boolean hasNext() {
            return this._queue.size() > 0;
        }

        @Override
        public T next() {
            IteratorCtx ctx = (IteratorCtx)this._queue.top();
            Object val = ctx._curVal;
            if (ctx.fetch()) {
                this._queue.updateTop();
            } else {
                this._queue.pop();
            }
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class IteratorCtx {
            public Iterator<T> _iterator;
            public T _curVal;

            public IteratorCtx(Iterator<T> iterator) {
                this._iterator = iterator;
                this._curVal = null;
            }

            public boolean fetch() {
                if (this._iterator.hasNext()) {
                    this._curVal = this._iterator.next();
                    return true;
                }
                this._curVal = null;
                return false;
            }
        }
    }
}

