/*
 * Decompiled with CFR 0.152.
 */
package org.scribe.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.scribe.exceptions.OAuthException;
import org.scribe.utils.Preconditions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLUtils {
    private static final String EMPTY_STRING = "";
    private static final String UTF_8 = "UTF-8";
    private static final char PAIR_SEPARATOR = '=';
    private static final char PARAM_SEPARATOR = '&';
    private static final String ERROR_MSG = String.format("Cannot find specified encoding: %s", "UTF-8");
    private static final Set<EncodingRule> ENCODING_RULES;

    public static String formURLEncodeMap(Map<String, String> map) {
        Preconditions.checkNotNull(map, "Cannot url-encode a null object");
        return map.size() <= 0 ? EMPTY_STRING : URLUtils.doFormUrlEncode(map);
    }

    private static String doFormUrlEncode(Map<String, String> map) {
        StringBuffer encodedString = new StringBuffer(map.size() * 20);
        for (String key : map.keySet()) {
            if (encodedString.length() > 0) {
                encodedString.append('&');
            }
            encodedString.append(URLUtils.percentEncode(key)).append('=').append(URLUtils.percentEncode(map.get(key)));
        }
        return encodedString.toString();
    }

    public static String percentEncode(String string) {
        Preconditions.checkNotNull(string, "Cannot encode null string");
        try {
            String encoded = URLEncoder.encode(string, UTF_8);
            for (EncodingRule rule : ENCODING_RULES) {
                encoded = rule.apply(encoded);
            }
            return encoded;
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException(ERROR_MSG, uee);
        }
    }

    public static String percentDecode(String string) {
        Preconditions.checkNotNull(string, "Cannot decode null string");
        try {
            return URLDecoder.decode(string, UTF_8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException(ERROR_MSG, uee);
        }
    }

    static {
        HashSet<EncodingRule> rules = new HashSet<EncodingRule>();
        rules.add(new EncodingRule("*", "%2A"));
        rules.add(new EncodingRule("+", "%20"));
        rules.add(new EncodingRule("%7E", "~"));
        ENCODING_RULES = Collections.unmodifiableSet(rules);
    }

    private static final class EncodingRule {
        private final String ch;
        private final String toCh;

        EncodingRule(String ch, String toCh) {
            this.ch = ch;
            this.toCh = toCh;
        }

        String apply(String string) {
            return string.replace(this.ch, this.toCh);
        }
    }
}

