/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Set;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class FunctionSQLInvoked
extends Expression {
    RoutineSchema routineSchema;
    Routine routine;
    Expression condition = Expression.EXPR_TRUE;

    FunctionSQLInvoked(RoutineSchema routineSchema) {
        super(routineSchema.isAggregate() ? 98 : 27);
        this.routineSchema = routineSchema;
    }

    public void setArguments(Expression[] newNodes) {
        this.nodes = newNodes;
    }

    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        HsqlList conditionSet = this.condition.resolveColumnReferences(session, rangeVarArray, rangeCount, null, false);
        if (conditionSet != null) {
            ExpressionColumn.checkColumnsResolved(conditionSet);
        }
        if (this.isSelfAggregate()) {
            if (unresolvedSet == null) {
                unresolvedSet = new ArrayListIdentity();
            }
            unresolvedSet.add(this);
            return unresolvedSet;
        }
        return super.resolveColumnReferences(session, rangeVarArray, rangeCount, unresolvedSet, acceptsSequences);
    }

    public void resolveTypes(Session session, Expression parent) {
        int i;
        Type[] types = new Type[this.nodes.length];
        for (i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            e.resolveTypes(session, this);
            types[i] = e.dataType;
        }
        this.routine = this.routineSchema.getSpecificRoutine(types);
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].dataType != null) continue;
            this.nodes[i].dataType = this.routine.getParameterTypes()[i];
        }
        this.dataType = this.routine.getReturnType();
        this.condition.resolveTypes(session, null);
    }

    private Object getValueInternal(Session session, Object[] aggregateData) {
        boolean isValue = false;
        int variableCount = this.routine.getVariableCount();
        int extraArg = this.routine.javaMethodWithConnection ? 1 : 0;
        Object[] data = ValuePool.emptyObjectArray;
        boolean push = true;
        if (extraArg + this.nodes.length > 0) {
            if (this.opType == 98) {
                data = new Object[this.routine.getParameterCount()];
                for (int i = 0; i < aggregateData.length; ++i) {
                    data[i + 1] = aggregateData[i];
                }
            } else {
                data = new Object[this.nodes.length + extraArg];
            }
            if (!this.routine.isPSM()) {
                JDBCConnection connection = session.getInternalConnection();
                if (extraArg > 0) {
                    data[0] = connection;
                }
            }
        }
        Type[] dataTypes = this.routine.getParameterTypes();
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            Object value = e.getValue(session, dataTypes[i]);
            if (value == null) {
                if (this.routine.isNullInputOutput()) {
                    return null;
                }
                if (!this.routine.getParameter(i).isNullable()) {
                    return Result.newErrorResult(Error.error(4811));
                }
            }
            if (this.routine.isPSM()) {
                data[i] = value;
                continue;
            }
            data[i + extraArg] = e.dataType.convertSQLToJava(session, value);
        }
        Result result = this.routine.invoke(session, data, aggregateData, push);
        session.releaseInternalConnection();
        if (result.isError()) {
            throw result.getException();
        }
        if (isValue) {
            return result.valueData;
        }
        return result;
    }

    public Object getValue(Session session) {
        if (this.opType == 5) {
            Object value = session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
            return value;
        }
        Object returnValue = this.getValueInternal(session, null);
        if (returnValue instanceof Result) {
            Result result = (Result)returnValue;
            if (result.isError()) {
                throw result.getException();
            }
            if (result.isSimpleValue()) {
                returnValue = result.getValueObject();
            } else if (result.isData()) {
                returnValue = result;
            } else {
                throw Error.error(4605, this.routine.getName().name);
            }
        }
        return returnValue;
    }

    public Result getResult(Session session) {
        Object value = this.getValueInternal(session, null);
        if (value instanceof Result) {
            return (Result)value;
        }
        return Result.newPSMResult(value);
    }

    void collectObjectNames(Set set) {
        set.add(this.routine.getSpecificName());
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.routineSchema.getName().getSchemaQualifiedStatementName());
        sb.append('(');
        int nodeCount = this.nodes.length;
        if (this.opType == 98) {
            nodeCount = 1;
        }
        for (int i = 0; i < nodeCount; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.nodes[i].getSQL());
        }
        sb.append(')');
        return sb.toString();
    }

    public String describe(Session session, int blanks) {
        return super.describe(session, blanks);
    }

    boolean isSelfAggregate() {
        return this.routineSchema.isAggregate();
    }

    public boolean isDeterministic() {
        return this.routine.isDeterministic();
    }

    public boolean equals(Expression other) {
        if (!(other instanceof FunctionSQLInvoked)) {
            return false;
        }
        FunctionSQLInvoked o = (FunctionSQLInvoked)other;
        if (this.opType == other.opType && this.routineSchema == o.routineSchema && this.routine == o.routine && this.condition.equals(o.condition)) {
            return super.equals(other);
        }
        return false;
    }

    public Object updateAggregatingValue(Session session, Object currValue) {
        if (!this.condition.testCondition(session)) {
            return currValue;
        }
        Object[] array = (Object[])currValue;
        if (array == null) {
            array = new Object[3];
        }
        array[0] = Boolean.FALSE;
        this.getValueInternal(session, array);
        return array;
    }

    public Object getAggregatedValue(Session session, Object currValue) {
        Object[] array = (Object[])currValue;
        if (array == null) {
            array = new Object[3];
        }
        array[0] = Boolean.TRUE;
        Result result = (Result)this.getValueInternal(session, array);
        if (result.isError()) {
            throw result.getException();
        }
        return result.getValueObject();
    }

    public Expression getCondition() {
        return this.condition;
    }

    public boolean hasCondition() {
        return this.condition != null && this.condition != Expression.EXPR_TRUE;
    }

    public void setCondition(Expression e) {
        this.condition = e;
    }
}

