/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringUtil;

public class HsqlDateTime {
    private static Locale defaultLocale = Locale.UK;
    private static long currentDateMillis;
    public static final Calendar tempCalDefault;
    public static final Calendar tempCalGMT;
    private static final Date tempDate;
    private static final String sdfdPattern = "yyyy-MM-dd";
    static SimpleDateFormat sdfd;
    private static final String sdftPattern = "HH:mm:ss";
    static SimpleDateFormat sdft;
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss";
    static SimpleDateFormat sdfts;
    private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    static SimpleDateFormat sdftsSys;
    private static Date sysDate;
    private static final char[][] dateTokens;
    private static final String[] javaDateTokens;
    private static final int[] sqlIntervalCodes;
    private static final char e = '\uffff';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getDateSeconds(String s) {
        try {
            SimpleDateFormat simpleDateFormat = sdfd;
            synchronized (simpleDateFormat) {
                Date d = sdfd.parse(s);
                return d.getTime() / 1000L;
            }
        }
        catch (Exception e) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(long seconds) {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sysDate.setTime(seconds * 1000L);
            return sdfd.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimestampSeconds(String s) {
        try {
            SimpleDateFormat simpleDateFormat = sdfts;
            synchronized (simpleDateFormat) {
                Date d = sdfts.parse(s);
                return d.getTime() / 1000L;
            }
        }
        catch (Exception e) {
            throw Error.error(3407);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getTimestampString(StringBuffer sb, long seconds, int nanos, int scale) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            tempDate.setTime(seconds * 1000L);
            sb.append(sdfts.format(tempDate));
            if (scale > 0) {
                sb.append('.');
                sb.append(StringUtil.toZeroPaddedString(nanos, 9, scale));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long millis) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sysDate.setTime(millis);
            return sdfts.format(sysDate);
        }
    }

    public static synchronized long getCurrentDateMillis(long millis) {
        if (millis - currentDateMillis >= 86400000L) {
            currentDateMillis = HsqlDateTime.getNormalisedDate(millis);
        }
        return currentDateMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSytemTimeString() {
        SimpleDateFormat simpleDateFormat = sdftsSys;
        synchronized (simpleDateFormat) {
            sysDate.setTime(System.currentTimeMillis());
            return sdftsSys.format(sysDate);
        }
    }

    public static void resetToDate(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static void resetToTime(Calendar cal) {
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(14, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisToCalendar(Calendar calendar, long millis) {
        calendar.clear();
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            tempCalGMT.setTimeInMillis(millis);
            calendar.set(tempCalGMT.get(1), tempCalGMT.get(2), tempCalGMT.get(5), tempCalGMT.get(11), tempCalGMT.get(12), tempCalGMT.get(13));
            return calendar.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertMillisFromCalendar(Calendar calendar, long millis) {
        Calendar calendar2 = tempCalGMT;
        synchronized (calendar2) {
            tempCalGMT.clear();
            calendar.setTimeInMillis(millis);
            tempCalGMT.set(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
            return tempCalGMT.getTimeInMillis();
        }
    }

    public static void setTimeInMillis(Calendar cal, long millis) {
        cal.setTimeInMillis(millis);
    }

    public static long getTimeInMillis(Calendar cal) {
        return cal.getTimeInMillis();
    }

    public static long convertToNormalisedTime(long t) {
        return HsqlDateTime.convertToNormalisedTime(t, tempCalGMT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedTime(long t, Calendar cal) {
        Calendar calendar = cal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, t);
            HsqlDateTime.resetToDate(cal);
            long t1 = HsqlDateTime.getTimeInMillis(cal);
            return t - t1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertToNormalisedDate(long t, Calendar cal) {
        Calendar calendar = cal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, t);
            HsqlDateTime.resetToDate(cal);
            return HsqlDateTime.getTimeInMillis(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(long t) {
        Calendar cal;
        Calendar calendar = cal = tempCalGMT;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, t);
            HsqlDateTime.resetToTime(cal);
            return HsqlDateTime.getTimeInMillis(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(Calendar cal, long t) {
        Calendar calendar = cal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, t);
            HsqlDateTime.resetToTime(cal);
            return HsqlDateTime.getTimeInMillis(cal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(long d) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalGMT, d);
            HsqlDateTime.resetToDate(tempCalGMT);
            return HsqlDateTime.getTimeInMillis(tempCalGMT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(Calendar cal, long d) {
        Calendar calendar = cal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(cal, d);
            HsqlDateTime.resetToDate(cal);
            return HsqlDateTime.getTimeInMillis(cal);
        }
    }

    public static int getZoneSeconds(Calendar cal) {
        return (cal.get(15) + cal.get(16)) / 1000;
    }

    public static int getZoneMillis(Calendar cal, long millis) {
        return cal.getTimeZone().getOffset(millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDateTimePart(long m, int part) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(m);
            return tempCalGMT.get(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTruncatedPart(long m, int part) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(m);
            switch (part) {
                case 262: {
                    int year = tempCalGMT.get(1);
                    int week = tempCalGMT.get(3);
                    tempCalGMT.clear();
                    tempCalGMT.set(1, year);
                    tempCalGMT.set(3, week);
                    break;
                }
                default: {
                    HsqlDateTime.zeroFromPart(tempCalGMT, part);
                }
            }
            return tempCalGMT.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getRoundedPart(long m, int part) {
        Calendar calendar = tempCalGMT;
        synchronized (calendar) {
            tempCalGMT.setTimeInMillis(m);
            switch (part) {
                case 101: {
                    if (tempCalGMT.get(2) <= 6) break;
                    tempCalGMT.add(1, 1);
                    break;
                }
                case 102: {
                    if (tempCalGMT.get(5) <= 15) break;
                    tempCalGMT.add(2, 1);
                    break;
                }
                case 103: {
                    if (tempCalGMT.get(11) <= 11) break;
                    tempCalGMT.add(5, 1);
                    break;
                }
                case 104: {
                    if (tempCalGMT.get(12) <= 29) break;
                    tempCalGMT.add(11, 1);
                    break;
                }
                case 105: {
                    if (tempCalGMT.get(13) <= 29) break;
                    tempCalGMT.add(12, 1);
                    break;
                }
                case 106: {
                    if (tempCalGMT.get(14) <= 499) break;
                    tempCalGMT.add(13, 1);
                    break;
                }
                case 262: {
                    int year = tempCalGMT.get(1);
                    int week = tempCalGMT.get(3);
                    int day = tempCalGMT.get(7);
                    if (day > 3) {
                        ++week;
                    }
                    tempCalGMT.clear();
                    tempCalGMT.set(1, year);
                    tempCalGMT.set(3, week);
                    return tempCalGMT.getTimeInMillis();
                }
            }
            HsqlDateTime.zeroFromPart(tempCalGMT, part);
            return tempCalGMT.getTimeInMillis();
        }
    }

    static void zeroFromPart(Calendar cal, int part) {
        switch (part) {
            case 101: {
                cal.set(2, 0);
            }
            case 102: {
                cal.set(5, 1);
            }
            case 103: {
                cal.set(11, 0);
            }
            case 104: {
                cal.set(12, 0);
            }
            case 105: {
                cal.set(13, 0);
            }
            case 106: {
                cal.set(14, 0);
            }
        }
    }

    public static Date toDate(String string, String pattern, SimpleDateFormat format) {
        Date date;
        String javaPattern = HsqlDateTime.toJavaDatePattern(pattern);
        int matchIndex = javaPattern.indexOf("*IY");
        if (matchIndex >= 0) {
            throw Error.error(3472);
        }
        matchIndex = javaPattern.indexOf("*WW");
        if (matchIndex >= 0) {
            throw Error.error(3472);
        }
        try {
            format.applyPattern(javaPattern);
            date = format.parse(string);
        }
        catch (Exception e) {
            throw Error.error(3407, e.toString());
        }
        return date;
    }

    public static String toFormattedDate(Date date, String pattern, SimpleDateFormat format) {
        int matchLength;
        Calendar cal;
        String javaPattern = HsqlDateTime.toJavaDatePattern(pattern);
        try {
            format.applyPattern(javaPattern);
        }
        catch (Exception e) {
            throw Error.error(3472);
        }
        String result = format.format(date);
        int matchIndex = result.indexOf("*IY");
        if (matchIndex >= 0) {
            cal = format.getCalendar();
            matchLength = 3;
            int temp = result.indexOf("*IYYY");
            if (temp >= 0) {
                matchLength = 5;
                matchIndex = temp;
            }
            int year = cal.get(1);
            int weekOfYear = cal.get(3);
            if (weekOfYear == 1 && cal.get(6) > 360) {
                ++year;
            }
            String yearString = String.valueOf(year);
            if (matchLength == 3) {
                yearString = yearString.substring(yearString.length() - 2);
            }
            StringBuilder sb = new StringBuilder(result);
            sb.replace(matchIndex, matchIndex + matchLength, yearString);
            result = sb.toString();
        }
        if ((matchIndex = result.indexOf("*WW")) >= 0) {
            cal = format.getCalendar();
            matchLength = 3;
            int dayOfYear = cal.get(6);
            int weekOfYear = (dayOfYear - 1) / 7 + 1;
            StringBuilder sb = new StringBuilder(result);
            sb.replace(matchIndex, matchIndex + matchLength, String.valueOf(weekOfYear));
            result = sb.toString();
        }
        return result;
    }

    public static String toJavaDatePattern(String format) {
        int len = format.length();
        StringBuffer sb = new StringBuffer(len);
        Tokenizer tokenizer = new Tokenizer();
        for (int i = 0; i <= len; ++i) {
            char ch;
            char c = ch = i == len ? (char)'\uffff' : (char)format.charAt(i);
            if (tokenizer.isInQuotes()) {
                if (tokenizer.isQuoteChar(ch)) {
                    ch = '\'';
                } else if (ch == '\'') {
                    sb.append(ch);
                }
                sb.append(ch);
                continue;
            }
            if (tokenizer.next(ch, i)) continue;
            if (tokenizer.consumed) {
                int index = tokenizer.getLastMatch();
                sb.append(javaDateTokens[index]);
                i = tokenizer.matchOffset;
            } else if (tokenizer.isQuoteChar(ch)) {
                ch = '\'';
                sb.append(ch);
            } else if (tokenizer.isLiteral(ch)) {
                sb.append(ch);
            } else if (ch != '\uffff') {
                throw Error.error(3407, format.substring(i));
            }
            tokenizer.reset();
        }
        if (tokenizer.isInQuotes()) {
            throw Error.error(3407);
        }
        String javaPattern = sb.toString();
        return javaPattern;
    }

    public static int toStandardIntervalPart(String format) {
        int len = format.length();
        Tokenizer tokenizer = new Tokenizer();
        for (int i = 0; i <= len; ++i) {
            char ch;
            char c = ch = i == len ? (char)'\uffff' : (char)format.charAt(i);
            if (tokenizer.next(ch, i)) continue;
            int index = tokenizer.getLastMatch();
            if (index >= 0) {
                return sqlIntervalCodes[index];
            }
            return -1;
        }
        return -1;
    }

    static /* synthetic */ char[][] access$200() {
        return dateTokens;
    }

    static {
        tempCalDefault = new GregorianCalendar();
        tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale);
        tempDate = new Date(0L);
        sdfd = new SimpleDateFormat(sdfdPattern);
        sdft = new SimpleDateFormat(sdftPattern);
        sdfts = new SimpleDateFormat(sdftsPattern);
        sdftsSys = new SimpleDateFormat(sdftsSysPattern);
        tempCalGMT.setLenient(false);
        sdfd.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfd.setLenient(false);
        sdft.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdft.setLenient(false);
        sdfts.setCalendar(new GregorianCalendar(TimeZone.getTimeZone("GMT"), defaultLocale));
        sdfts.setLenient(false);
        currentDateMillis = HsqlDateTime.getNormalisedDate(System.currentTimeMillis());
        sysDate = new Date();
        dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'M', 'M'}, {'D', 'A', 'Y'}, {'D', 'Y'}, {'W', 'W'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}, {'F', 'F'}};
        javaDateTokens = new String[]{"yyyy", "'*IYYY'", "yyyy", "'*IY'", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "MM", "EEEE", "EE", "'*WW'", "w", "dd", "D", "HH", "KK", "KK", "mm", "ss", "aaa", "aaa", "aaa", "aaa", "S"};
        sqlIntervalCodes = new int[]{-1, -1, 101, -1, 101, -1, -1, -1, -1, 102, 102, 102, -1, -1, 262, -1, 103, 103, 104, -1, 104, 105, 106, -1, -1, -1, -1, -1};
    }

    static class Tokenizer {
        private int lastMatched;
        private int matchOffset;
        private int offset;
        private long state;
        private boolean consumed;
        private boolean isInQuotes;
        private boolean matched;
        private final char quoteChar = (char)34;
        private final char[] literalChars = defaultLiterals;
        private static char[] defaultLiterals = new char[]{' ', ',', '-', '.', '/', ':', ';'};
        char[][] tokens = HsqlDateTime.access$200();

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.lastMatched = -1;
            this.offset = -1;
            this.state = 0L;
            this.consumed = false;
            this.matched = false;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.lastMatched;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public boolean wasMatched() {
            return this.matched;
        }

        public boolean isInQuotes() {
            return this.isInQuotes;
        }

        public boolean isQuoteChar(char ch) {
            if (this.quoteChar == ch) {
                this.isInQuotes = !this.isInQuotes;
                return true;
            }
            return false;
        }

        public boolean isLiteral(char ch) {
            return ArrayUtil.isInSortedArray(ch, this.literalChars);
        }

        private boolean isZeroBit(int bit) {
            return (this.state & 1L << bit) == 0L;
        }

        private void setBit(int bit) {
            this.state |= 1L << bit;
        }

        public boolean next(char ch, int position) {
            int index = ++this.offset;
            int len = this.offset + 1;
            int left = 0;
            this.matched = false;
            int i = this.tokens.length;
            while (--i >= 0) {
                if (!this.isZeroBit(i)) continue;
                if (this.tokens[i][index] == ch) {
                    if (this.tokens[i].length == len) {
                        this.setBit(i);
                        this.lastMatched = i;
                        this.consumed = true;
                        this.matched = true;
                        this.matchOffset = position;
                        continue;
                    }
                    ++left;
                    continue;
                }
                this.setBit(i);
            }
            return left > 0;
        }
    }
}

