/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.constant.Constable;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;

public class ParserCommand
extends ParserDDL {
    ParserCommand(Session session, Scanner t) {
        super(session, t);
    }

    Statement compileStatement(int props) {
        Statement cs = this.compilePart(props);
        if (this.token.tokenType == 848) {
            if (cs.getSchemaName() == null) {
                cs.setSchemaHsqlName(this.session.getCurrentSchemaHsqlName());
            }
            return cs;
        }
        throw this.unexpectedToken();
    }

    HsqlArrayList compileStatements(String sql, Result cmd) {
        HsqlArrayList list = new HsqlArrayList();
        Statement cs = null;
        this.reset(sql);
        while (this.token.tokenType != 848) {
            try {
                this.lastError = null;
                cs = this.compilePart(cmd.getExecuteProperties());
            }
            catch (HsqlException e) {
                if (this.lastError != null && this.lastError.getLevel() > e.getLevel()) {
                    throw this.lastError;
                }
                throw e;
            }
            if (!cs.isExplain && cs.getParametersMetaData().getColumnCount() > 0) {
                throw Error.error(5575);
            }
            list.add(cs);
        }
        int returnType = cmd.getStatementType();
        if (returnType != 0) {
            int group = cs.getGroup();
            if (group == 2003) {
                if (returnType == 1) {
                    throw Error.error(1253);
                }
            } else if (returnType == 2) {
                throw Error.error(1254);
            }
        }
        return list;
    }

    private Statement compilePart(int props) {
        Statement cs;
        this.compileContext.reset();
        this.setParsePosition(this.getPosition());
        if (this.token.tokenType == 849) {
            this.read();
        }
        switch (this.token.tokenType) {
            case 251: 
            case 278: 
            case 319: 
            case 786: {
                cs = this.compileCursorSpecification(props, false, RangeVariable.emptyArray);
                break;
            }
            case 308: {
                cs = this.compileShortCursorSpecification(props);
                break;
            }
            case 135: {
                cs = this.compileInsertStatement(RangeVariable.emptyArray);
                break;
            }
            case 303: {
                cs = this.compileUpdateStatement(RangeVariable.emptyArray);
                break;
            }
            case 166: {
                cs = this.compileMergeStatement(RangeVariable.emptyArray);
                break;
            }
            case 79: {
                cs = this.compileDeleteStatement(RangeVariable.emptyArray);
                break;
            }
            case 295: {
                cs = this.compileDeleteStatement(RangeVariable.emptyArray);
                break;
            }
            case 25: {
                cs = this.compileCallStatement(this.session.sessionContext.sessionVariablesRange, false);
                break;
            }
            case 254: {
                cs = this.compileSet();
                break;
            }
            case 267: {
                cs = this.compileStartTransaction();
                break;
            }
            case 44: {
                cs = this.compileCommit();
                break;
            }
            case 241: {
                cs = this.compileRollback();
                break;
            }
            case 246: {
                cs = this.compileSavepoint();
                break;
            }
            case 233: {
                cs = this.compileReleaseSavepoint();
                break;
            }
            case 55: {
                cs = this.compileCreate();
                break;
            }
            case 4: {
                cs = this.compileAlter();
                break;
            }
            case 88: {
                cs = this.compileDrop();
                break;
            }
            case 121: 
            case 239: {
                cs = this.compileGrantOrRevoke();
                break;
            }
            case 575: {
                cs = this.compileComment();
                break;
            }
            case 599: {
                cs = this.compileLock();
                break;
            }
            case 47: {
                cs = this.compileConnect();
                break;
            }
            case 84: {
                cs = this.compileDisconnect();
                break;
            }
            case 619: {
                cs = this.compileScript();
                break;
            }
            case 621: {
                cs = this.compileShutdown();
                break;
            }
            case 562: {
                cs = this.compileBackup();
                break;
            }
            case 572: {
                cs = this.compileCheckpoint();
                break;
            }
            case 586: {
                cs = this.compileExplainPlan();
                break;
            }
            case 77: {
                cs = this.compileDeclare();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (cs.type != 76) {
            cs.setSQL(this.getLastPart());
        }
        if (this.token.tokenType == 791) {
            this.read();
        } else if (this.token.tokenType == 848) {
            // empty if block
        }
        return cs;
    }

    private Statement compileDeclare() {
        Statement cs = this.compileDeclareLocalTableOrNull();
        if (cs != null) {
            return cs;
        }
        ColumnSchema[] variables = this.readLocalVariableDeclarationOrNull();
        if (variables != null) {
            Object[] args = new Object[]{variables};
            cs = new StatementSession(1075, args);
            return cs;
        }
        cs = this.compileDeclareCursor(false, null);
        return cs;
    }

    private Statement compileScript() {
        String name = null;
        this.read();
        if (this.token.tokenType == 845) {
            name = this.readQuotedString();
        }
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{name};
        return new StatementCommand(1004, args, null, names);
    }

    private Statement compileConnect() {
        String password = null;
        this.read();
        this.readThis(305);
        this.checkIsSimpleName();
        String userName = this.token.tokenString;
        this.read();
        if (!this.session.isProcessingLog) {
            this.readThis(611);
            password = this.readPassword();
        }
        Expression[] args = new Expression[]{new ExpressionValue(userName, Type.SQL_VARCHAR), new ExpressionValue(password, Type.SQL_VARCHAR)};
        StatementSession cs = new StatementSession(76, args);
        return cs;
    }

    private StatementCommand compileSetDefault() {
        this.read();
        switch (this.token.tokenType) {
            case 596: {
                this.read();
                this.readThis(497);
                HsqlNameManager.HsqlName schema = this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{schema};
                return new StatementCommand(1031, args);
            }
            case 236: {
                this.read();
                this.readThis(605);
                this.readThis(245);
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementCommand(1040, args);
            }
            case 278: {
                this.read();
                this.readThis(535);
                int type = 4;
                switch (this.token.tokenType) {
                    case 605: {
                        break;
                    }
                    case 570: {
                        type = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] args = new Object[]{ValuePool.getInt(type)};
                return new StatementCommand(1032, args);
            }
            case 424: {
                int level;
                this.read();
                this.readThis(432);
                switch (this.token.tokenType) {
                    case 480: {
                        this.read();
                        this.readThis(365);
                        level = 2;
                        break;
                    }
                    case 506: {
                        this.read();
                        level = 8;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] args = new Object[]{ValuePool.getInt(level)};
                return new StatementCommand(1050, args);
            }
        }
        throw this.unexpectedToken();
    }

    private StatementCommand compileSetProperty() {
        Object value;
        this.read();
        HsqlDatabaseProperties props = this.database.getProperties();
        this.checkIsSimpleName();
        this.checkIsDelimitedIdentifier();
        String property = this.token.tokenString;
        boolean isboolean = props.isBoolean(this.token.tokenString);
        boolean isintegral = props.isIntegral(this.token.tokenString);
        boolean isstring = props.isString(this.token.tokenString);
        if (!(isboolean || isintegral || isstring)) {
            throw Error.error(5555, property);
        }
        int typeCode = isboolean ? 16 : (isintegral ? 4 : 1);
        this.read();
        if (this.token.tokenType == 294) {
            value = Boolean.TRUE;
            if (!isboolean) {
                throw Error.error(5563, this.token.tokenString);
            }
        } else if (this.token.tokenType == 106) {
            value = Boolean.FALSE;
            if (!isboolean) {
                throw Error.error(5563, this.token.tokenString);
            }
        } else {
            this.checkIsValue();
            value = this.token.tokenValue;
            if (this.token.dataType.typeCode != typeCode) {
                throw Error.error(5563, this.token.tokenString);
            }
        }
        this.read();
        Object[] args = new Object[]{property, value};
        return new StatementCommand(1035, args);
    }

    private Statement compileSet() {
        int position = super.getPosition();
        this.session.setScripting(false);
        this.read();
        switch (this.token.tokenType) {
            case 348: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    HsqlNameManager.HsqlName name = this.readSchemaName();
                    Object[] args = new Object[]{name};
                    return new StatementSession(66, args);
                }
                if (!e.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] args = new Expression[]{e};
                return new StatementSession(66, args);
            }
            case 497: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    HsqlNameManager.HsqlName name = this.readSchemaName();
                    Object[] args = new Object[]{name};
                    return new StatementSession(74, args);
                }
                if (!e.getDataType().isCharacterType()) {
                    throw Error.error(2200);
                }
                if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                    throw Error.error(2200);
                }
                Expression[] args = new Expression[]{e};
                return new StatementSession(74, args);
            }
            case 180: {
                this.read();
                this.readThis(358);
                HsqlArrayList charsets = null;
                if (this.readIfThis(112)) {
                    charsets = new HsqlArrayList();
                    while (true) {
                        SchemaObject charset = this.readSchemaObjectName(14);
                        charsets.add(charset);
                        if (this.token.tokenType != 774) break;
                        this.read();
                    }
                }
                Object[] args = new Object[]{null, Boolean.FALSE, charsets};
                return new StatementSession(136, args);
            }
            case 358: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null || !e.getDataType().isCharacterType()) {
                    throw Error.error(4650);
                }
                HsqlArrayList charsets = null;
                if (this.readIfThis(112)) {
                    charsets = new HsqlArrayList();
                    while (true) {
                        SchemaObject charset = this.readSchemaObjectName(14);
                        charsets.add(charset);
                        if (this.token.tokenType != 774) break;
                        this.read();
                    }
                }
                Object[] args = new Object[]{e, Boolean.TRUE, charsets};
                return new StatementSession(136, args);
            }
            case 281: {
                this.read();
                return this.compileSetTimeZone();
            }
            case 490: {
                this.read();
                return this.compileSetRole();
            }
            case 508: {
                this.read();
                return this.compileSessionSettings();
            }
            case 526: {
                this.read();
                Object[] args = this.processTransactionCharacteristics();
                if (args[0] == null && args[1] == null) {
                    throw this.unexpectedToken();
                }
                return new StatementSession(75, args);
            }
            case 560: {
                this.read();
                Boolean mode = this.processTrueOrFalseObject();
                Object[] args = new Object[]{mode};
                return new StatementSession(1064, args);
            }
            case 615: {
                this.read();
                Boolean readonly = this.processTrueOrFalseObject();
                Object[] args = new Object[]{readonly};
                return new StatementSession(109, args);
            }
            case 592: {
                this.read();
                Boolean mode = this.processTrueOrFalseObject();
                Object[] args = new Object[]{mode};
                return new StatementSession(1042, args);
            }
            case 603: {
                this.read();
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementSession(1065, args);
            }
            case 78: {
                this.read();
                this.readThis(278);
                this.readThis(535);
                int type = 4;
                switch (this.token.tokenType) {
                    case 605: {
                        break;
                    }
                    case 570: {
                        type = 5;
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                this.read();
                Object[] args = new Object[]{ValuePool.getInt(type)};
                return new StatementCommand(1032, args);
            }
            case 278: {
                this.read();
                Table t = this.readTableName();
                Object[] args = new Object[]{t.getName(), null};
                switch (this.token.tokenType) {
                    default: {
                        throw this.unexpectedToken();
                    }
                    case 513: {
                        this.read();
                        return this.compileTableSource(t);
                    }
                    case 480: {
                        this.read();
                        boolean readonly = false;
                        if (this.token.tokenType == 547) {
                            this.read();
                        } else {
                            this.readThis(195);
                            readonly = true;
                        }
                        args[1] = readonly;
                        return new StatementCommand(1194, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
                    }
                    case 615: {
                        this.read();
                        Boolean readonly = this.processTrueOrFalseObject();
                        args[1] = readonly;
                        return new StatementCommand(1194, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
                    }
                    case 595: {
                        this.read();
                        this.checkIsValue();
                        String value = this.token.tokenString;
                        this.read();
                        args[1] = value;
                        return new StatementCommand(1193, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
                    }
                    case 535: {
                        int newType;
                        this.read();
                        if (this.token.tokenType == 570) {
                            newType = 5;
                        } else if (this.token.tokenType == 605) {
                            newType = 4;
                        } else {
                            throw super.unexpectedToken();
                        }
                        this.read();
                        args[1] = new Integer(newType);
                        return new StatementCommand(1197, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
                    }
                    case 574: 
                }
                this.read();
                this.readThis(194);
                OrderedHashSet set = new OrderedHashSet();
                this.readThis(786);
                this.readSimpleColumnNames(set, t);
                this.readThis(772);
                int[] colIndex = t.getColumnIndexes(set);
                args[1] = colIndex;
                return new StatementCommand(1198, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
            }
            case 629: {
                this.read();
                int delay = 0;
                if (this.token.tokenType == 294) {
                    delay = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 106) {
                    delay = 0;
                    this.read();
                } else {
                    delay = this.readInteger();
                    if (delay < 0) {
                        delay = 0;
                    }
                    if (this.token.tokenType == 606) {
                        this.read();
                    } else {
                        delay *= 1000;
                    }
                }
                Object[] args = new Object[]{new Integer(delay)};
                return new StatementCommand(1026, args, null, null);
            }
            case 611: {
                this.read();
                String password = this.readPassword();
                Object[] args = new Object[]{null, password};
                return new StatementCommand(1062, args);
            }
            case 596: {
                this.read();
                this.readThis(497);
                HsqlNameManager.HsqlName schema = this.token.tokenType == 78 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] args = new Object[]{null, schema};
                return new StatementCommand(1061, args);
            }
            case 588: {
                return this.compileSetFilesProperty();
            }
            case 580: {
                return this.compileSetDatabaseProperty();
            }
            case 613: {
                return this.compileSetProperty();
            }
        }
        this.rewind(position);
        return this.compileSetStatement(this.session.sessionContext.sessionVariablesRange);
    }

    StatementCommand compileSetDatabaseProperty() {
        this.read();
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 561: {
                this.read();
                this.readThis(117);
                Routine routine = this.readCreateDatabaseAuthenticationFunction();
                Object[] args = new Object[]{routine};
                return new StatementCommand(1033, args, null, null);
            }
            case 358: {
                this.read();
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                this.read();
                Object[] args = new Object[]{name};
                return new StatementCommand(1041, args, null, null);
            }
            case 78: {
                return this.compileSetDefault();
            }
            case 585: {
                this.read();
                this.readThis(682);
                this.readThis(432);
                Integer value = this.readIntegerObject();
                Object[] args = new Object[]{value};
                return new StatementCommand(1015, args, null, null);
            }
            case 590: {
                this.read();
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementCommand(1034, args, null, null);
            }
            case 611: {
                this.read();
                this.readThis(37);
                this.readThis(117);
                Routine routine = this.readCreatePasswordCheckFunction();
                Object[] args = new Object[]{routine};
                return new StatementCommand(1036, args, null, null);
            }
            case 616: {
                this.read();
                this.readThis(594);
                boolean mode = this.processTrueOrFalse();
                Object[] args = new Object[]{mode};
                return new StatementCommand(1046, args, null, null);
            }
            case 261: {
                this.read();
                int type = 1047;
                Boolean flag = null;
                String property = null;
                switch (this.token.tokenType) {
                    case 446: {
                        this.read();
                        property = "sql.enforce_names";
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 222: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.enforce_refs";
                        break;
                    }
                    case 512: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.enforce_size";
                        break;
                    }
                    case 627: {
                        this.read();
                        flag = this.processTrueOrFalseObject();
                        property = "sql.enforce_types";
                        break;
                    }
                    case 623: {
                        this.read();
                        if (this.readIfThis(79)) {
                            property = "sql.enforce_tdc_delete";
                        } else {
                            this.readThis(303);
                            property = "sql.enforce_tdc_update";
                        }
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    case 287: {
                        this.read();
                        this.readThis(626);
                        this.readThis(627);
                        flag = this.processTrueOrFalseObject();
                        property = "jdbc.translate_tti_types";
                        break;
                    }
                    case 643: {
                        this.read();
                        this.readThis(451);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.concat_nulls";
                        break;
                    }
                    case 299: {
                        this.read();
                        this.readThis(451);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.unique_nulls";
                        break;
                    }
                    case 49: {
                        this.read();
                        this.readThis(295);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.convert_trunc";
                        break;
                    }
                    case 87: {
                        this.read();
                        this.readThis(608);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.double_nan";
                        break;
                    }
                    case 602: {
                        this.read();
                        this.readThis(142);
                        this.readThis(681);
                        flag = this.processTrueOrFalseObject();
                        property = "sql.longvar_is_lob";
                        break;
                    }
                    case 622: {
                        this.read();
                        if (this.token.tokenString.equals("ORA")) {
                            this.read();
                            property = "sql.syntax_ora";
                        } else if (this.token.tokenString.equals("MSS")) {
                            this.read();
                            property = "sql.syntax_mss";
                        } else if (this.token.tokenString.equals("MYS")) {
                            this.read();
                            property = "sql.syntax_mys";
                        } else if (this.token.tokenString.equals("PGS")) {
                            this.read();
                            property = "sql.syntax_pgs";
                        } else {
                            throw this.unexpectedToken();
                        }
                        flag = this.processTrueOrFalseObject();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                Object[] args = new Object[]{property, flag};
                return new StatementCommand(type, args, null, null);
            }
            case 625: {
                this.read();
                this.readThis(278);
                this.readThis(381);
                String source = this.readQuotedString();
                Object[] args = new Object[]{source};
                return new StatementCommand(1048, args, null, null);
            }
            case 526: {
                this.read();
                if (this.readIfThis(241)) {
                    this.readThis(194);
                    this.readThis(581);
                    Boolean mode = this.processTrueOrFalseObject();
                    StatementCommand cs = new StatementCommand(1051, new Object[]{mode}, null, null);
                    return cs;
                }
                this.readThis(578);
                int mode = 0;
                switch (this.token.tokenType) {
                    case 689: {
                        this.read();
                        mode = 2;
                        break;
                    }
                    case 690: {
                        this.read();
                        mode = 1;
                        break;
                    }
                    case 600: {
                        this.read();
                        mode = 0;
                    }
                }
                HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
                Object[] args = new Object[]{ValuePool.getInt(mode)};
                StatementCommand cs = new StatementCommand(1049, args, null, names);
                return cs;
            }
            case 299: {
                this.read();
                this.readThis(445);
                this.isUndelimitedSimpleName();
                String name = this.token.tokenString;
                this.read();
                if (name.length() != 16) {
                    throw Error.error(5555);
                }
                if (!Charset.isInSet(name, Charset.unquotedIdentifier) || !Charset.startsWith(name, Charset.uppercaseLetters)) {
                    throw Error.error(5501);
                }
                Object[] args = new Object[]{name};
                return new StatementCommand(1052, args, null, null);
            }
        }
        throw this.unexpectedToken();
    }

    StatementCommand compileSetFilesProperty() {
        this.read();
        int type = 0;
        Boolean flag = null;
        Integer value = null;
        this.checkDatabaseUpdateAuthorisation();
        switch (this.token.tokenType) {
            case 599: {
                this.read();
                flag = this.processTrueOrFalseObject();
                type = 1017;
                break;
            }
            case 569: {
                this.read();
                if (this.readIfThis(512)) {
                    value = this.readIntegerObject();
                    type = 1013;
                    break;
                }
                this.readThis(245);
                value = this.readIntegerObject();
                type = 1012;
                break;
            }
            case 496: {
                this.read();
                value = this.readIntegerObject();
                type = 1023;
                break;
            }
            case 681: {
                this.read();
                this.readThis(496);
                value = this.readIntegerObject();
                type = 1016;
                break;
            }
            case 582: {
                this.read();
                type = 1014;
                value = this.readIntegerObject();
                break;
            }
            case 691: {
                this.read();
                if (this.readIfThis(512)) {
                    value = this.readIntegerObject();
                } else {
                    flag = this.processTrueOrFalseObject();
                }
                type = 1020;
                break;
            }
            case 562: {
                this.read();
                type = 1011;
                this.readThis(417);
                flag = this.processTrueOrFalseObject();
                break;
            }
            case 682: {
                this.read();
                if (this.readIfThis(512)) {
                    type = 1019;
                    value = this.readIntegerObject();
                    break;
                }
                type = 1018;
                flag = this.processTrueOrFalseObject();
                break;
            }
            case 624: {
                this.read();
                this.readThis(472);
                type = 1025;
                value = this.readIntegerObject();
                break;
            }
            case 547: {
                this.read();
                this.readThis(583);
                type = 1026;
                int delay = 0;
                if (this.token.tokenType == 294) {
                    delay = this.database.getProperties().getDefaultWriteDelay();
                    this.read();
                } else if (this.token.tokenType == 106) {
                    delay = 0;
                    this.read();
                } else {
                    delay = this.readInteger();
                    if (delay < 0) {
                        delay = 0;
                    }
                    if (this.token.tokenType == 606) {
                        this.read();
                    } else {
                        delay *= 1000;
                    }
                }
                value = new Integer(delay);
                break;
            }
            case 619: {
                this.read();
                this.readThis(589);
                if (this.token.tokenType == 625) {
                    this.read();
                    value = new Integer(0);
                } else {
                    this.readThis(577);
                    value = new Integer(3);
                }
                type = 1024;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] args = new Object[]{flag == null ? (Constable)value : (Constable)flag};
        return new StatementCommand(type, args, null, this.database.schemaManager.getCatalogNameArray());
    }

    Object[] processTransactionCharacteristics() {
        int level = 0;
        boolean readonly = false;
        Object[] args = new Object[2];
        block10: while (true) {
            switch (this.token.tokenType) {
                case 480: {
                    if (args[0] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 195) {
                        this.read();
                        readonly = true;
                    } else {
                        this.readThis(547);
                        readonly = false;
                    }
                    args[0] = readonly;
                    continue block10;
                }
                case 424: {
                    if (args[1] != null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(432);
                    switch (this.token.tokenType) {
                        case 506: {
                            this.read();
                            level = 8;
                            break;
                        }
                        case 480: {
                            this.read();
                            if (this.token.tokenType == 365) {
                                this.read();
                                level = 2;
                                break;
                            }
                            if (this.token.tokenType == 537) {
                                this.read();
                                level = 1;
                                break;
                            }
                            throw this.unexpectedToken();
                        }
                        case 482: {
                            this.read();
                            this.readThis(480);
                            level = 4;
                            break;
                        }
                        default: {
                            throw this.unexpectedToken();
                        }
                    }
                    args[1] = new Integer(level);
                    continue block10;
                }
                case 774: {
                    if (args[0] == null && args[1] == null) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block10;
                }
            }
            break;
        }
        if (!readonly && level == 1) {
            throw this.unexpectedToken("WRITE");
        }
        return args;
    }

    private Statement compileCommit() {
        boolean chain = false;
        this.read();
        this.readIfThis(546);
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 180) {
                this.read();
            } else {
                chain = true;
            }
            this.readThis(350);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{chain};
        StatementSession cs = new StatementSession(11, args);
        return cs;
    }

    private Statement compileStartTransaction() {
        this.read();
        this.readThis(526);
        Object[] args = this.processTransactionCharacteristics();
        StatementSession cs = new StatementSession(111, args);
        return cs;
    }

    private Statement compileLock() {
        this.read();
        this.readThis(278);
        OrderedHashSet readSet = new OrderedHashSet();
        OrderedHashSet writeSet = new OrderedHashSet();
        while (true) {
            Table table = this.readTableName();
            switch (this.token.tokenType) {
                case 480: {
                    this.read();
                    readSet.add(table.getName());
                    break;
                }
                case 547: {
                    this.read();
                    writeSet.add(table.getName());
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (this.token.tokenType != 774) break;
            this.read();
        }
        Object[] writeTableNames = new HsqlNameManager.HsqlName[writeSet.size()];
        writeSet.toArray(writeTableNames);
        readSet.removeAll(writeTableNames);
        Object[] readTableNames = new HsqlNameManager.HsqlName[readSet.size()];
        readSet.toArray(readTableNames);
        StatementSession cs = new StatementSession(1063, (HsqlNameManager.HsqlName[])readTableNames, (HsqlNameManager.HsqlName[])writeTableNames);
        return cs;
    }

    private Statement compileRollback() {
        boolean chain = false;
        String savepoint = null;
        this.read();
        if (this.token.tokenType == 285) {
            this.read();
            this.readThis(246);
            this.checkIsSimpleName();
            savepoint = this.token.tokenString;
            this.read();
            String sql = this.getLastPart();
            Object[] args = new Object[]{savepoint};
            StatementSession cs = new StatementSession(1067, args);
            return cs;
        }
        if (this.token.tokenType == 546) {
            this.read();
        }
        if (this.token.tokenType == 5) {
            this.read();
            if (this.token.tokenType == 180) {
                this.read();
            } else {
                chain = true;
            }
            this.readThis(350);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{chain};
        StatementSession cs = new StatementSession(62, args);
        return cs;
    }

    private Statement compileSavepoint() {
        this.read();
        this.checkIsSimpleName();
        String name = this.token.tokenString;
        this.read();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name};
        return new StatementSession(63, args);
    }

    private Statement compileReleaseSavepoint() {
        this.read();
        this.readThis(246);
        String name = this.token.tokenString;
        this.read();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name};
        return new StatementSession(57, args);
    }

    private Statement compileSessionSettings() {
        switch (this.token.tokenType) {
            case 354: {
                this.read();
                this.readThis(10);
                this.readThis(526);
                Object[] args = this.processTransactionCharacteristics();
                return new StatementSession(109, args);
            }
            case 15: {
                this.read();
                Expression e = this.XreadValueSpecificationOrNull();
                if (e == null) {
                    throw Error.error(5584);
                }
                e.resolveTypes(this.session, null);
                if (e.isUnresolvedParam()) {
                    e.dataType = Type.SQL_VARCHAR;
                }
                if (e.dataType == null || !e.dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                Expression[] args = new Expression[]{e, null};
                return new StatementSession(76, args);
            }
            case 236: {
                this.read();
                this.readThis(605);
                this.readThis(245);
                Integer size = this.readIntegerObject();
                Object[] args = new Object[]{size};
                return new StatementSession(1066, args);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileSetRole() {
        Expression e;
        if (this.token.tokenType == 181) {
            this.read();
            e = new ExpressionValue(null, Type.SQL_VARCHAR);
        } else {
            e = this.XreadValueSpecificationOrNull();
            if (e == null) {
                throw Error.error(4100);
            }
            if (!e.getDataType().isCharacterType()) {
                throw Error.error(2200);
            }
            if (!(e.getType() == 1 || e.getType() == 28 && ((FunctionSQL)e).isValueFunction())) {
                throw Error.error(2200);
            }
        }
        String sql = this.getLastPart();
        return new StatementSession(73, new Expression[]{e});
    }

    private Statement compileSetTimeZone() {
        Expression e;
        this.readThis(549);
        if (this.token.tokenType == 157) {
            this.read();
            e = new ExpressionValue(null, Type.SQL_INTERVAL_HOUR_TO_MINUTE);
        } else {
            e = this.XreadIntervalValueExpression();
            HsqlList unresolved = e.resolveColumnReferences(this.session, RangeVariable.emptyArray, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            e.resolveTypes(this.session, null);
            if (e.dataType == null) {
                throw Error.error(5563);
            }
            if (e.dataType.typeCode != 111) {
                throw Error.error(5563);
            }
        }
        String sql = this.getLastPart();
        return new StatementSession(71, new Expression[]{e});
    }

    private Statement compileShutdown() {
        this.session.checkAdmin();
        int closemode = 2;
        this.read();
        switch (this.token.tokenType) {
            case 593: {
                closemode = 1;
                this.read();
                break;
            }
            case 576: {
                closemode = 3;
                this.read();
                break;
            }
            case 619: {
                closemode = 4;
                this.read();
            }
        }
        if (this.token.tokenType == 791) {
            this.read();
        }
        if (this.token.tokenType != 848) {
            throw this.unexpectedToken();
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{new Integer(closemode)};
        StatementCommand cs = new StatementCommand(1003, args, null, null);
        return cs;
    }

    private Statement compileBackup() {
        this.read();
        this.readThis(580);
        this.readThis(285);
        String path = this.readQuotedString();
        Boolean blockingMode = null;
        Boolean scriptMode = null;
        Boolean compression = null;
        block6: while (true) {
            switch (this.token.tokenType) {
                case 566: {
                    if (blockingMode != null) {
                        throw this.unexpectedToken();
                    }
                    blockingMode = Boolean.TRUE;
                    this.read();
                    continue block6;
                }
                case 619: {
                    if (scriptMode != null) {
                        throw this.unexpectedToken();
                    }
                    scriptMode = Boolean.TRUE;
                    this.read();
                    continue block6;
                }
                case 577: {
                    if (compression != null) {
                        throw this.unexpectedToken();
                    }
                    compression = Boolean.TRUE;
                    this.read();
                    continue block6;
                }
                case 183: {
                    this.read();
                    if (this.token.tokenType == 577) {
                        if (compression != null) {
                            throw this.unexpectedToken();
                        }
                        compression = Boolean.FALSE;
                        this.read();
                        continue block6;
                    }
                    if (this.token.tokenType == 566) {
                        blockingMode = Boolean.FALSE;
                        this.read();
                        continue block6;
                    }
                    throw this.unexpectedToken();
                }
            }
            break;
        }
        if (scriptMode != null) {
            throw this.unsupportedFeature("SCRIPT");
        }
        scriptMode = Boolean.FALSE;
        if (blockingMode == null) {
            throw this.unexpectedTokenRequire("BLOCKING");
        }
        if (compression == null) {
            compression = Boolean.TRUE;
        }
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{path, blockingMode, scriptMode, compression};
        StatementCommand cs = new StatementCommand(1001, args, null, names);
        return cs;
    }

    private Statement compileCheckpoint() {
        boolean defrag = false;
        this.read();
        if (this.token.tokenType == 582) {
            defrag = true;
            this.read();
        } else if (this.token.tokenType == 791) {
            this.read();
        }
        if (this.token.tokenType != 848) {
            throw this.unexpectedToken();
        }
        HsqlNameManager.HsqlName[] names = this.database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{defrag};
        StatementCommand cs = new StatementCommand(1002, args, null, names);
        return cs;
    }

    public static Statement getAutoCheckpointStatement(Database database) {
        HsqlNameManager.HsqlName[] names = database.schemaManager.getCatalogAndBaseTableNames();
        Object[] args = new Object[]{Boolean.FALSE};
        StatementCommand cs = new StatementCommand(1002, args, null, names);
        cs.setCompileTimestamp(database.txManager.getGlobalChangeTimestamp());
        cs.setSQL("CHECKPOINT");
        return cs;
    }

    private Statement compileDisconnect() {
        this.read();
        String sql = "DISCONNECT";
        StatementSession cs = new StatementSession(22, (Object[])null);
        return cs;
    }

    private Statement compileExplainPlan() {
        this.read();
        this.readThis(612);
        this.readThis(112);
        Statement cs = this.compilePart(0);
        cs.setDescribe();
        return cs;
    }

    private Statement compileTableSource(Table t) {
        String source;
        String sql;
        boolean isSourceHeader = false;
        boolean isDesc = false;
        Object[] args = new Object[5];
        args[0] = t.getName();
        if (!t.isText()) {
            HsqlException e = Error.error(321);
        }
        if (this.token.tokenType == 194) {
            this.read();
            sql = this.getLastPart();
            args[1] = Boolean.TRUE;
            return new StatementCommand(1195, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
        }
        if (this.token.tokenType == 610) {
            this.read();
            sql = this.getLastPart();
            args[1] = Boolean.FALSE;
            return new StatementCommand(1195, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
        }
        if (this.token.tokenType == 591) {
            this.read();
            isSourceHeader = true;
        }
        if (this.token.tokenType == 847) {
            source = this.token.tokenString;
            this.read();
        } else {
            source = this.readQuotedString();
        }
        if (!isSourceHeader && this.token.tokenType == 389) {
            isDesc = true;
            this.read();
        }
        sql = this.getLastPart();
        args[2] = source;
        args[3] = isDesc;
        args[4] = isSourceHeader;
        int type = isSourceHeader ? 1196 : 1195;
        return new StatementCommand(type, args, null, new HsqlNameManager.HsqlName[]{t.getName()});
    }
}

