/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Row;
import org.hsqldb.TableBase;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.PersistentStore;

public class RowAVL
extends Row {
    public NodeAVL nPrimaryNode;

    protected RowAVL(TableBase table, Object[] data) {
        super(table, data);
    }

    public RowAVL(TableBase table, Object[] data, int position, PersistentStore store) {
        super(table, data);
        this.position = position;
        this.setNewNodes(store);
    }

    public void setNewNodes(PersistentStore store) {
        int indexCount = store.getAccessorKeys().length;
        NodeAVL n = this.nPrimaryNode = new NodeAVL(this);
        for (int i = 1; i < indexCount; ++i) {
            n = n.nNext = new NodeAVL(this);
        }
    }

    public NodeAVL getNode(int index) {
        NodeAVL n = this.nPrimaryNode;
        while (index-- > 0) {
            n = n.nNext;
        }
        return n;
    }

    NodeAVL getNextNode(NodeAVL n) {
        n = n == null ? this.nPrimaryNode : n.nNext;
        return n;
    }

    public NodeAVL insertNode(int index) {
        NodeAVL backnode = this.getNode(index - 1);
        NodeAVL newnode = new NodeAVL(this);
        newnode.nNext = backnode.nNext;
        backnode.nNext = newnode;
        return newnode;
    }

    public void clearNonPrimaryNodes() {
        NodeAVL n = this.nPrimaryNode.nNext;
        while (n != null) {
            n.delete();
            n.iBalance = 0;
            n = n.nNext;
        }
    }

    public void delete(PersistentStore store) {
        NodeAVL n = this.nPrimaryNode;
        while (n != null) {
            n.delete();
            n = n.nNext;
        }
    }

    public void restore() {
    }

    public void destroy() {
        ++JavaSystem.memoryRecords;
        this.clearNonPrimaryNodes();
        NodeAVL n = this.nPrimaryNode.nNext;
        while (n != null) {
            NodeAVL last = n;
            n = n.nNext;
            last.nNext = null;
        }
        this.nPrimaryNode = null;
    }
}

