/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDML;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongValueHashMap;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;

public final class StatementManager {
    private Database database;
    private IntKeyHashMap schemaMap;
    private LongKeyHashMap csidMap;
    private long next_cs_id;

    StatementManager(Database database) {
        this.database = database;
        this.schemaMap = new IntKeyHashMap();
        this.csidMap = new LongKeyHashMap();
        this.next_cs_id = 0L;
    }

    synchronized void reset() {
        this.schemaMap.clear();
        this.csidMap.clear();
        this.next_cs_id = 0L;
    }

    private long nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private long getStatementID(HsqlNameManager.HsqlName schema, String sql) {
        LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schema.hashCode());
        if (sqlMap == null) {
            return -1L;
        }
        return sqlMap.get((Object)sql, -1);
    }

    public synchronized Statement getStatement(Session session, long csid) {
        Statement cs = (Statement)this.csidMap.get(csid);
        if (cs == null) {
            return null;
        }
        if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            if ((cs = this.recompileStatement(session, cs)) == null) {
                this.freeStatement(csid);
                return null;
            }
            this.csidMap.put(csid, cs);
        }
        return cs;
    }

    public synchronized Statement getStatement(Session session, Statement statement) {
        long csid = statement.getID();
        Statement cs = (Statement)this.csidMap.get(csid);
        if (cs != null) {
            return this.getStatement(session, csid);
        }
        if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp() && (cs = this.recompileStatement(session, statement)) == null) {
            this.freeStatement(csid);
            return null;
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement recompileStatement(Session session, Statement cs) {
        Statement newStatement;
        boolean setGenerated;
        HsqlNameManager.HsqlName oldSchema;
        block7: {
            block6: {
                oldSchema = session.getCurrentSchemaHsqlName();
                HsqlNameManager.HsqlName schema = cs.getSchemaName();
                session.setSchema(schema.name);
                setGenerated = cs.generatedResultMetaData() != null;
                newStatement = session.compileStatement(cs.getSQL(), cs.getResultProperties());
                if (cs.getResultMetaData().areTypesCompatible(newStatement.getResultMetaData())) break block6;
                Statement statement = null;
                Object var10_12 = null;
                session.setCurrentSchemaHsqlName(oldSchema);
                return statement;
            }
            if (cs.getParametersMetaData().areTypesCompatible(newStatement.getParametersMetaData())) break block7;
            Statement statement = null;
            Object var10_13 = null;
            session.setCurrentSchemaHsqlName(oldSchema);
            return statement;
        }
        try {
            block8: {
                try {
                    ResultMetaData newMeta = newStatement.getResultMetaData();
                    newStatement.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
                    if (!setGenerated) break block8;
                    StatementDML si = (StatementDML)cs;
                    newStatement.setGeneratedColumnInfo(si.generatedType, si.generatedInputMetaData);
                }
                catch (Throwable t) {
                    Statement statement = null;
                    Object var10_15 = null;
                    session.setCurrentSchemaHsqlName(oldSchema);
                    return statement;
                }
            }
            Object var10_14 = null;
            session.setCurrentSchemaHsqlName(oldSchema);
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            session.setCurrentSchemaHsqlName(oldSchema);
            throw throwable;
        }
        return newStatement;
    }

    private long registerStatement(long csid, Statement cs) {
        if (csid < 0L) {
            csid = this.nextID();
            int schemaid = cs.getSchemaName().hashCode();
            LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schemaid);
            if (sqlMap == null) {
                sqlMap = new LongValueHashMap();
                this.schemaMap.put(schemaid, sqlMap);
            }
            sqlMap.put(cs.getSQL(), csid);
        }
        cs.setID(csid);
        cs.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
        this.csidMap.put(csid, cs);
        return csid;
    }

    synchronized void freeStatement(long csid) {
        if (csid == -1L) {
            return;
        }
        Statement cs = (Statement)this.csidMap.remove(csid);
        if (cs != null) {
            int schemaid = cs.getSchemaName().hashCode();
            LongValueHashMap sqlMap = (LongValueHashMap)this.schemaMap.get(schemaid);
            String sql = cs.getSQL();
            sqlMap.remove(sql);
        }
    }

    synchronized Statement compile(Session session, Result cmd) throws Throwable {
        String sql = cmd.getMainString();
        long csid = this.getStatementID(session.currentSchema, sql);
        Statement cs = (Statement)this.csidMap.get(csid);
        if (cs == null || !cs.isValid() || cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            int props = cmd.getExecuteProperties();
            cs = session.compileStatement(sql, props);
            csid = this.registerStatement(csid, cs);
        }
        cs.setGeneratedColumnInfo(cmd.getGeneratedResultType(), cmd.getGeneratedResultMetaData());
        return cs;
    }
}

