/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import java.io.IOException;
import java.util.Comparator;
import java.util.TreeMap;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorData
extends RowSetNavigator
implements Comparator {
    public static final Object[][] emptyTable = new Object[0][];
    int currentOffset;
    int baseBlockSize;
    Object[][] table = emptyTable;
    final Session session;
    QueryExpression queryExpression;
    int visibleColumnCount;
    boolean isSimpleAggregate;
    Object[] simpleAggregateData;
    private Index mainIndex;
    TreeMap rowMap;
    LongKeyHashMap idMap;

    RowSetNavigatorData(Session session) {
        this.session = session;
    }

    public RowSetNavigatorData(Session session, QuerySpecification select) {
        this.session = session;
        this.queryExpression = select;
        this.rangePosition = select.resultRangePosition;
        this.visibleColumnCount = select.getColumnCount();
        boolean bl = this.isSimpleAggregate = select.isAggregated && !select.isGrouped;
        if (select.isGrouped) {
            this.mainIndex = select.groupIndex;
            this.rowMap = new TreeMap(this);
        }
        if (select.idIndex != null) {
            this.idMap = new LongKeyHashMap();
        }
    }

    public RowSetNavigatorData(Session session, QueryExpression queryExpression) {
        this.session = session;
        this.queryExpression = queryExpression;
        this.visibleColumnCount = queryExpression.getColumnCount();
    }

    public RowSetNavigatorData(Session session, RowSetNavigator navigator) {
        this.session = session;
        this.setCapacity(navigator.size);
        while (navigator.hasNext()) {
            this.add(navigator.getNext());
        }
    }

    public void sortFull(Session session) {
        this.mainIndex = this.queryExpression.fullIndex;
        ArraySort.sort((Object[])this.table, 0, this.size, this);
        this.reset();
    }

    public void sortOrder(Session session) {
        if (this.queryExpression.orderIndex != null) {
            this.mainIndex = this.queryExpression.orderIndex;
            ArraySort.sort((Object[])this.table, 0, this.size, this);
        }
        this.reset();
    }

    public void sortOrderUnion(Session session, SortAndSlice sortAndSlice) {
        if (sortAndSlice.index != null) {
            this.mainIndex = sortAndSlice.index;
            ArraySort.sort((Object[])this.table, 0, this.size, this);
            this.reset();
        }
    }

    public void add(Object[] data) {
        this.ensureCapacity();
        this.table[this.size] = data;
        ++this.size;
        if (this.rowMap != null) {
            this.rowMap.put(data, data);
        }
        if (this.idMap != null) {
            Long id = (Long)data[this.visibleColumnCount];
            this.idMap.put(id, data);
        }
    }

    public boolean addRow(Row row) {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    public void update(Object[] oldData, Object[] newData) {
    }

    void addAdjusted(Object[] data, int[] columnMap) {
        data = this.projectData(data, columnMap);
        this.add(data);
    }

    void insertAdjusted(Object[] data, int[] columnMap) {
        this.projectData(data, columnMap);
        this.insert(data);
    }

    Object[] projectData(Object[] data, int[] columnMap) {
        if (columnMap == null) {
            data = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.visibleColumnCount);
        } else {
            Object[] newData = new Object[this.visibleColumnCount];
            ArrayUtil.projectRow(data, columnMap, newData);
            data = newData;
        }
        return data;
    }

    void insert(Object[] data) {
        this.ensureCapacity();
        System.arraycopy(this.table, this.currentPos, this.table, this.currentPos + 1, this.size - this.currentPos);
        this.table[this.currentPos] = data;
        ++this.size;
    }

    public void clear() {
        this.table = emptyTable;
        this.size = this.table.length;
        this.reset();
    }

    public boolean absolute(int position) {
        return super.absolute(position);
    }

    public Object[] getCurrent() {
        if (this.currentPos < 0 || this.currentPos >= this.size) {
            return null;
        }
        if (this.currentPos == this.currentOffset + this.table.length) {
            this.getBlock(this.currentOffset + this.table.length);
        }
        return this.table[this.currentPos - this.currentOffset];
    }

    public Row getCurrentRow() {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    public Object[] getNextRowData() {
        return this.next() ? this.getCurrent() : null;
    }

    public boolean next() {
        return super.next();
    }

    public void remove() {
        System.arraycopy(this.table, this.currentPos + 1, this.table, this.currentPos, this.size - this.currentPos - 1);
        this.table[this.size - 1] = null;
        --this.currentPos;
        --this.size;
    }

    public void reset() {
        super.reset();
    }

    public void close() {
        super.close();
    }

    public boolean isMemory() {
        return true;
    }

    public void read(RowInputInterface in, ResultMetaData meta) throws IOException {
    }

    public void write(RowOutputInterface out, ResultMetaData meta) throws IOException {
        this.reset();
        out.writeLong(this.id);
        out.writeInt(this.size);
        out.writeInt(0);
        out.writeInt(this.size);
        while (this.hasNext()) {
            Object[] data = this.getNext();
            out.writeData(meta.getExtendedColumnCount(), meta.columnTypes, data, null, null);
        }
        this.reset();
    }

    public Object[] getData(long rowId) {
        return (Object[])this.idMap.get(rowId);
    }

    public void copy(RowSetNavigatorData other, int[] rightColumnIndexes) {
        while (other.hasNext()) {
            Object[] currentData = other.getNext();
            this.addAdjusted(currentData, rightColumnIndexes);
        }
    }

    public void union(Session session, RowSetNavigatorData other) {
        this.removeDuplicates(session);
        other.removeDuplicates(session);
        this.mainIndex = this.queryExpression.fullIndex;
        while (other.hasNext()) {
            Object[] currentData = other.getNext();
            int position = ArraySort.searchFirst((Object[])this.table, 0, this.size, currentData, this);
            if (position >= 0) continue;
            this.currentPos = position = -position - 1;
            this.insert(currentData);
        }
        other.close();
        this.reset();
    }

    public void unionAll(Session session, RowSetNavigatorData other) {
        other.reset();
        while (other.hasNext()) {
            Object[] currentData = other.getNext();
            this.add(currentData);
        }
        other.close();
        this.reset();
    }

    public void intersect(Session session, RowSetNavigatorData other) {
        this.removeDuplicates(session);
        other.sortFull(session);
        while (this.hasNext()) {
            Object[] currentData = this.getNext();
            boolean hasRow = other.containsRow(currentData);
            if (hasRow) continue;
            this.remove();
        }
        other.close();
        this.reset();
    }

    public void intersectAll(Session session, RowSetNavigatorData other) {
        Object[] compareData = null;
        Object[] otherData = null;
        this.sortFull(session);
        other.sortFull(session);
        RowIterator it = this.queryExpression.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean newGroup;
            Object[] currentData = this.getNext();
            boolean bl = newGroup = compareData == null || this.queryExpression.fullIndex.compareRowNonUnique(session, currentData, compareData, this.visibleColumnCount) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.findFirstRow(currentData);
            }
            if ((otherData = it.getNext()) != null && this.queryExpression.fullIndex.compareRowNonUnique(session, currentData, otherData, this.visibleColumnCount) == 0) continue;
            this.remove();
        }
        other.close();
        this.reset();
    }

    public void except(Session session, RowSetNavigatorData other) {
        this.removeDuplicates(session);
        other.sortFull(session);
        while (this.hasNext()) {
            Object[] currentData = this.getNext();
            boolean hasRow = other.containsRow(currentData);
            if (!hasRow) continue;
            this.remove();
        }
        other.close();
        this.reset();
    }

    public void exceptAll(Session session, RowSetNavigatorData other) {
        Object[] compareData = null;
        Object[] otherData = null;
        this.sortFull(session);
        other.sortFull(session);
        RowIterator it = this.queryExpression.fullIndex.emptyIterator();
        while (this.hasNext()) {
            boolean newGroup;
            Object[] currentData = this.getNext();
            boolean bl = newGroup = compareData == null || this.queryExpression.fullIndex.compareRowNonUnique(session, currentData, compareData, this.queryExpression.fullIndex.getColumnCount()) != 0;
            if (newGroup) {
                compareData = currentData;
                it = other.findFirstRow(currentData);
            }
            if ((otherData = it.getNext()) == null || this.queryExpression.fullIndex.compareRowNonUnique(session, currentData, otherData, this.queryExpression.fullIndex.getColumnCount()) != 0) continue;
            this.remove();
        }
        other.close();
        this.reset();
    }

    public boolean hasUniqueNotNullRows(Session session) {
        this.sortFull(session);
        this.reset();
        Object[] lastRowData = null;
        while (this.hasNext()) {
            Object[] currentData = this.getNext();
            if (this.hasNull(currentData)) continue;
            if (lastRowData != null && this.queryExpression.fullIndex.compareRow(session, lastRowData, currentData) == 0) {
                return false;
            }
            lastRowData = currentData;
        }
        return true;
    }

    public void removeDuplicates(Session session) {
        this.sortFull(session);
        this.reset();
        int lastRowPos = -1;
        Object[] lastRowData = null;
        while (this.hasNext()) {
            Object[] currentData = this.getNext();
            if (lastRowData == null) {
                lastRowPos = this.currentPos;
                lastRowData = currentData;
                continue;
            }
            if (this.queryExpression.fullIndex.compareRow(session, lastRowData, currentData) == 0) continue;
            lastRowData = currentData;
            this.table[++lastRowPos] = currentData;
        }
        this.size = lastRowPos + 1;
        this.reset();
    }

    public void trim(int limitstart, int limitcount) {
        int i;
        if (this.size == 0) {
            return;
        }
        if (limitstart >= this.size) {
            this.clear();
            return;
        }
        if (limitstart != 0) {
            this.reset();
            for (i = 0; i < limitstart; ++i) {
                this.next();
                this.remove();
            }
        }
        if (limitcount == 0 || limitcount >= this.size) {
            return;
        }
        this.reset();
        for (i = 0; i < limitcount; ++i) {
            this.next();
        }
        while (this.hasNext()) {
            this.next();
            this.remove();
        }
        this.reset();
    }

    boolean hasNull(Object[] data) {
        for (int i = 0; i < this.visibleColumnCount; ++i) {
            if (data[i] != null) continue;
            return true;
        }
        return false;
    }

    public Object[] getGroupData(Object[] data) {
        if (this.isSimpleAggregate) {
            if (this.simpleAggregateData == null) {
                this.simpleAggregateData = data;
                return null;
            }
            return this.simpleAggregateData;
        }
        return (Object[])this.rowMap.get(data);
    }

    boolean containsRow(Object[] data) {
        int position = ArraySort.searchFirst((Object[])this.table, 0, this.size, data, this);
        return position >= 0;
    }

    RowIterator findFirstRow(Object[] data) {
        int position = ArraySort.searchFirst((Object[])this.table, 0, this.size, data, this);
        position = position < 0 ? this.size : --position;
        return new DataIterator(position);
    }

    void getBlock(int offset) {
    }

    private void setCapacity(int newSize) {
        if (this.size > this.table.length) {
            this.table = new Object[newSize][];
        }
    }

    private void ensureCapacity() {
        if (this.size == this.table.length) {
            int newSize = this.size == 0 ? 4 : this.size * 2;
            Object[][] newTable = new Object[newSize][];
            System.arraycopy(this.table, 0, newTable, 0, this.size);
            this.table = newTable;
        }
    }

    void implement() {
        throw Error.error(201, "RSND");
    }

    public int compare(Object a, Object b) {
        return this.mainIndex.compareRow(this.session, (Object[])a, (Object[])b);
    }

    class DataIterator
    implements RowIterator {
        int pos;

        DataIterator(int position) {
            this.pos = position;
        }

        public Row getNextRow() {
            return null;
        }

        public Object[] getNext() {
            if (this.hasNext()) {
                ++this.pos;
                return RowSetNavigatorData.this.table[this.pos];
            }
            return null;
        }

        public boolean hasNext() {
            return this.pos < RowSetNavigatorData.this.size - 1;
        }

        public void remove() {
        }

        public boolean setRowColumns(boolean[] columns) {
            return false;
        }

        public void release() {
        }

        public long getRowId() {
            return 0L;
        }
    }
}

