/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.Serializable;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.Type;

public final class OtherType
extends Type {
    static final OtherType otherType = new OtherType();

    private OtherType() {
        super(1111, 1111, 0L, 0);
    }

    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public int getJDBCTypeCode() {
        return this.typeCode;
    }

    public Class getJDBCClass() {
        return Object.class;
    }

    public String getJDBCClassName() {
        return "java.lang.Object";
    }

    public int getSQLGenericTypeCode() {
        return this.typeCode;
    }

    public int typeCode() {
        return this.typeCode;
    }

    public String getNameString() {
        return "OTHER";
    }

    public String getDefinition() {
        return "OTHER";
    }

    public Type getAggregateType(Type other) {
        if (this.typeCode == other.typeCode) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        throw Error.error(5562);
    }

    public Type getCombinedType(Type other, int operation) {
        return this;
    }

    public int compare(Session session, Object a, Object b) {
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return 0;
    }

    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return a;
    }

    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        return a;
    }

    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a instanceof Serializable) {
            return a;
        }
        throw Error.error(5561);
    }

    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return StringConverter.byteArrayToHexString(((JavaObjectData)a).getBytes());
    }

    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        return StringConverter.byteArrayToSQLHexString(((JavaObjectData)a).getBytes());
    }

    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        return ((JavaObjectData)a).getObject();
    }

    public boolean canConvertFrom(Type otherType) {
        if (otherType.typeCode == this.typeCode) {
            return true;
        }
        return otherType.typeCode == 0;
    }

    public boolean isObjectType() {
        return true;
    }

    public static OtherType getOtherType() {
        return otherType;
    }
}

