/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.marketplace.util.comparator;

import com.liferay.marketplace.model.App;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;

/**
 * @author Ryan Park
 */
public class AppTitleComparator extends OrderByComparator {

	public static final String ORDER_BY_ASC = "title ASC";

	public static final String ORDER_BY_DESC = "title DESC";

	public static final String[] ORDER_BY_FIELDS = {"title"};

	public AppTitleComparator() {
		this(true);
	}

	public AppTitleComparator(boolean asc) {
		_asc = asc;
	}


	public int compare(Object obj1, Object obj2) {
		App app1 = (App)obj1;
		App app2 = (App)obj2;

		int value = StringUtil.toLowerCase(app1.getTitle()).compareTo(
			StringUtil.toLowerCase(app2.getTitle()));

		if (_asc) {
			return value;
		}
		else {
			return -value;
		}
	}


	public String getOrderBy() {
		if (_asc) {
			return ORDER_BY_ASC;
		}
		else {
			return ORDER_BY_DESC;
		}
	}


	public String[] getOrderByFields() {
		return ORDER_BY_FIELDS;
	}


	public boolean isAscending() {
		return _asc;
	}

	private boolean _asc;

}