/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.configuration;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERuntimeResourceQuery;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.security.soa3.configuration.GSSConfigurationManager;
import org.gcube.security.soa3.configuration.GSSConfigurationManagerImpl;

public class ISBasedConfiguration
implements GSSConfigurationManager {
    private GSSConfigurationManagerImpl internalConfiguration;
    private GCUBELog log = new GCUBELog((Object)this);
    private final String GET_SOA3_CONDITION = "$resource/Profile/Name eq 'SOA3'";
    private final String BASE_ENDPOINT = "base";

    public ISBasedConfiguration(GSSConfigurationManagerImpl internalConfiguration) {
        this.log.debug((Object)"IS Based configurator");
        this.internalConfiguration = internalConfiguration;
    }

    public boolean isSecurityEnabled(String serviceName) {
        return this.internalConfiguration.isSecurityEnabled(serviceName);
    }

    public String getServerUrl(String serviceName) {
        String endpoint = this.retrieveSoa3Url();
        if (endpoint == null) {
            endpoint = this.internalConfiguration.getServerUrl(serviceName);
        }
        return endpoint;
    }

    public boolean getCredentialPropagationPolicy(String serviceName) {
        return this.internalConfiguration.getCredentialPropagationPolicy(serviceName);
    }

    @Override
    public void setServiceProperties(String serviceName, Properties serviceProperties) {
        this.internalConfiguration.setServiceProperties(serviceName, serviceProperties);
    }

    public boolean servicePropertiesSet(String serviceName) {
        return this.internalConfiguration.servicePropertiesSet(serviceName);
    }

    public String retrieveSoa3Url() {
        String scope = ScopeProvider.instance.get();
        if (scope == null) {
            return null;
        }
        this.log.debug((Object)"Loading soa3 endopoint");
        this.log.debug((Object)("For scope " + scope));
        String endpoint = null;
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBERuntimeResourceQuery query = (GCUBERuntimeResourceQuery)client.getQuery(GCUBERuntimeResourceQuery.class);
            query.addGenericCondition("$resource/Profile/Name eq 'SOA3'");
            this.log.debug((Object)"Executing query...");
            List soa3Services = client.execute((ISQuery)query, GCUBEScope.getScope((String)scope));
            if (soa3Services == null || soa3Services.size() == 0) {
                this.log.debug((Object)"No entry found");
            } else {
                this.log.debug((Object)"Entry found");
                GCUBERuntimeResource soa3Service = (GCUBERuntimeResource)soa3Services.get(0);
                List accessPoints = soa3Service.getAccessPoints();
                Iterator accessPointIterator = accessPoints.iterator();
                while (accessPointIterator.hasNext() && endpoint == null) {
                    AccessPoint accessPoint = (AccessPoint)accessPointIterator.next();
                    String entryName = accessPoint.getEntryname();
                    if (!entryName.equals("base")) continue;
                    endpoint = accessPoint.getEndpoint();
                    this.log.debug((Object)("Endpoint " + endpoint));
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to contact the IS for an internal error", (Throwable)e);
        }
        return endpoint;
    }
}

