/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration.server;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.security.GCUBEAuthzPolicy;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.impl.GSSSecurityCredentials;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.ietf.jgss.GSSCredential;

public abstract class GCUBEServiceSecurityConfigurationManager
implements GCUBEServiceSecurityManager {
    protected GCUBELog logger;
    protected GCUBEServiceContext context;
    protected GCUBEProducer<GCUBEServiceSecurityManager.LifetimeTopic, Object> producer = new GCUBEProducer();
    protected SecurityCredentials serviceCredentials;
    protected GCUBESecurityManager.AuthMethod authMethod;
    protected boolean propagateCallerCredentials = true;

    public GCUBEServiceSecurityConfigurationManager() {
        this.logger = new GCUBELog((Object)this);
        this.authMethod = GCUBESecurityManager.AuthMethod.NONE;
    }

    public void initialise(GCUBEServiceContext ctxt) throws Exception {
        this.logger.debug((Object)"Initialising...");
        this.context = ctxt;
        this.producer.notify((GCUBETopic)GCUBEServiceSecurityManager.LifetimeTopic.POLICYUPDATE, new GCUBEEvent[]{new GCUBEServiceSecurityManager.LifetimeEvent()});
        this.logger.debug((Object)"Intialisation completed");
    }

    public void subscribe(GCUBEServiceSecurityManager.LifetimeConsumer c, GCUBEServiceSecurityManager.LifetimeTopic ... topics) {
        this.producer.subscribe((GCUBEConsumer)c, (GCUBETopic[])(topics == null | topics.length == 0 ? GCUBEServiceSecurityManager.LifetimeTopic.values() : topics));
    }

    public void unsubscribe(GCUBEServiceSecurityManager.LifetimeConsumer c, GCUBEServiceSecurityManager.LifetimeTopic ... topics) {
        this.producer.unsubscribe((GCUBEConsumer)c, (GCUBETopic[])(topics == null | topics.length == 0 ? GCUBEServiceSecurityManager.LifetimeTopic.values() : topics));
    }

    public SecurityCredentials getServiceCredentials() throws Exception {
        return this.serviceCredentials;
    }

    public GCUBEAuthzPolicy getPolicy() {
        return null;
    }

    public void setAuthMethod(GCUBESecurityManager.AuthMethod m) {
        this.authMethod = m;
    }

    public void propagateCallerCredentials(boolean propagateCallerCredentials) {
        this.propagateCallerCredentials = propagateCallerCredentials;
    }

    public void useCredentials(GSSCredential credentials) throws Exception {
        this.useCredentials((SecurityCredentials)new GSSSecurityCredentials(credentials));
    }
}

