/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.service;

import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.MainPackage;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.resources.service.Plugin;
import org.gcube.common.core.resources.service.ServiceDependency;
import org.gcube.common.core.resources.service.Software;
import org.gcube.common.resources.kxml.GCUBEResourceImpl;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.service.KConfiguration;
import org.gcube.common.resources.kxml.service.KMain;
import org.gcube.common.resources.kxml.service.KPlugin;
import org.gcube.common.resources.kxml.service.KServiceDependency;
import org.gcube.common.resources.kxml.service.KSoftware;
import org.gcube.common.resources.kxml.utils.KAny;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KGCUBEService
extends GCUBEService
implements GCUBEResourceImpl {
    @Override
    public synchronized void load(Reader reader) throws Exception {
        KGCUBEResource.load(this, reader);
    }

    @Override
    public synchronized void store(Writer writer) throws Exception {
        KGCUBEResource.store(this, writer);
    }

    @Override
    public InputStream getSchemaResource() {
        return KGCUBEService.class.getResourceAsStream("/org/gcube/common/resources/kxml/schemas/service.xsd");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void load(KXmlParser parser) throws Exception {
        this.getDependencies().clear();
        this.getPackages().clear();
        while (true) {
            switch (parser.next()) {
                case 2: {
                    if (parser.getName().equals("Description")) {
                        this.setDescription(parser.nextText().trim());
                    }
                    if (parser.getName().equals("Class")) {
                        this.setServiceClass(parser.nextText().trim());
                    }
                    if (parser.getName().equals("Name")) {
                        this.setServiceName(parser.nextText().trim());
                    }
                    if (parser.getName().equals("Version")) {
                        this.setVersion(parser.nextText().trim());
                    }
                    if (parser.getName().equals("Configuration")) {
                        this.setConfiguration(KConfiguration.load(parser));
                    }
                    if (parser.getName().equals("Dependency")) {
                        this.getDependencies().add(KServiceDependency.load(parser));
                    }
                    if (parser.getName().equals("Main")) {
                        this.getPackages().add(KMain.load(parser));
                    }
                    if (parser.getName().equals("Software")) {
                        this.getPackages().add(KSoftware.load(parser));
                    }
                    if (parser.getName().equals("Plugin")) {
                        this.getPackages().add(KPlugin.load(parser));
                    }
                    if (!parser.getName().equals("SpecificData")) break;
                    this.setSpecificData(KAny.load("SpecificData", parser));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Profile")) break;
                    return;
                }
                case 1: {
                    throw new Exception("Parsing failed at Profile");
                }
            }
        }
    }

    @Override
    public void store(KXmlSerializer serializer) throws Exception {
        serializer.startTag(KGCUBEResource.NS, "Profile");
        if (this.getDescription() != null) {
            serializer.startTag(KGCUBEResource.NS, "Description").text(this.getDescription().trim()).endTag(KGCUBEResource.NS, "Description");
        }
        if (this.getServiceClass() != null) {
            serializer.startTag(KGCUBEResource.NS, "Class").text(this.getServiceClass().trim()).endTag(KGCUBEResource.NS, "Class");
        }
        if (this.getServiceName() != null) {
            serializer.startTag(KGCUBEResource.NS, "Name").text(this.getServiceName().trim()).endTag(KGCUBEResource.NS, "Name");
        }
        if (this.getVersion() != null) {
            serializer.startTag(KGCUBEResource.NS, "Version").text(this.getVersion().trim()).endTag(KGCUBEResource.NS, "Version");
        }
        KConfiguration.store(this.getConfiguration(), serializer);
        if (this.getDependencies().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "Dependencies");
            for (ServiceDependency c : this.getDependencies()) {
                KServiceDependency.store(c, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "Dependencies");
        }
        if (this.getPackages().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "Packages");
            for (Package p : this.getPackages()) {
                if (p instanceof MainPackage) {
                    KMain.store((MainPackage)p, serializer);
                }
                if (p instanceof Software) {
                    KSoftware.store((Software)p, serializer);
                }
                if (!(p instanceof Plugin)) continue;
                KPlugin.store((Plugin)p, serializer);
            }
        }
        serializer.endTag(KGCUBEResource.NS, "Packages");
        KAny.store("SpecificData", this.getSpecificData(), serializer);
        serializer.endTag(KGCUBEResource.NS, "Profile");
    }
}

