/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.servicegroup.client;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.impl.servicegroup.client.ServiceGroupRegistrationClient;
import org.globus.wsrf.utils.FaultHelper;

public class ServiceGroupAdd
extends BaseClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ServiceGroupAdd baseClient = new ServiceGroupAdd();
        baseClient.setCustomUsage("[filename of registration file]");
        String registrationFilename = null;
        try {
            CommandLine line = baseClient.parse(args);
            List options = line.getArgList();
            if (options == null || options.isEmpty()) {
                System.err.println("Must specify a registration file");
                System.exit(1);
            } else {
                registrationFilename = (String)options.get(0);
            }
        }
        catch (ParseException e) {
            System.err.println("Parsing failed: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        try {
            ServiceGroupRegistrationClient regClient = new ServiceGroupRegistrationClient(baseClient);
            System.out.println("Processing configuration file...");
            regClient.processConfigFile(registrationFilename);
            ServiceGroupRegistrationClient serviceGroupRegistrationClient = regClient;
            synchronized (serviceGroupRegistrationClient) {
                try {
                    regClient.wait();
                }
                catch (InterruptedException ex) {
                    regClient.terminate();
                    System.out.println("Exiting...");
                    System.exit(1);
                }
            }
        }
        catch (Exception e) {
            if (baseClient.isDebugMode()) {
                FaultHelper.printStackTrace((Throwable)e);
            }
            System.err.println("Error: " + FaultHelper.getMessage((Throwable)e));
        }
    }
}

