/*
 * Decompiled with CFR 0.152.
 */
package org.globus.security.gridmap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.QuotedStringTokenizer;

public class GridMap
implements Serializable {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$security$gridmap$GridMap == null ? (class$org$globus$security$gridmap$GridMap = GridMap.class$("org.globus.security.gridmap.GridMap")) : class$org$globus$security$gridmap$GridMap).getName());
    private static final String COMMENT_CHARS = "#";
    private static final char[] EMAIL_KEYWORD_1 = new char[]{'e', '='};
    private static final char[] EMAIL_KEYWORD_2 = new char[]{'e', 'm', 'a', 'i', 'l', '='};
    private static final char[] UID_KEYWORD = new char[]{'u', 'i', 'd', '='};
    private static final int EMAIL_KEYWORD_1_L = 2;
    private static final int EMAIL_KEYWORD_2_L = 6;
    private static final int UID_KEYWORD_L = 4;
    private static final String EMAIL_KEYWORD = "emailaddress=";
    private static final String USERID_KEYWORD = "userid=";
    protected Map map;
    private File file;
    private long lastModified;
    private boolean ignoreErrors = false;
    static /* synthetic */ Class class$org$globus$security$gridmap$GridMap;

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public boolean getIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void load(String file) throws IOException {
        this.load(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.file = file;
            this.lastModified = file.lastModified();
            this.load(in);
            Object var4_3 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (in == null) throw throwable;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((InputStream)in).close();
            return;
        }
        catch (Exception e) {}
    }

    public void refresh() throws IOException {
        if (this.file == null) {
            return;
        }
        if (this.file.lastModified() != this.lastModified) {
            this.load(this.file);
        }
    }

    public void load(InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        HashMap<String, GridMapEntry> localMap = new HashMap<String, GridMapEntry>();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || COMMENT_CHARS.indexOf(line.charAt(0)) != -1) continue;
            QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(line);
            String globusID = null;
            if (!tokenizer.hasMoreTokens()) {
                if (this.ignoreErrors) {
                    logger.warn((Object)("Globus ID missing: " + line));
                    continue;
                }
                throw new IOException("Globus ID missing: " + line);
            }
            globusID = tokenizer.nextToken();
            String userIDs = null;
            if (!tokenizer.hasMoreTokens()) {
                if (this.ignoreErrors) {
                    logger.warn((Object)("User ID mapping missing: " + line));
                    continue;
                }
                throw new IOException("User ID mapping missing: " + line);
            }
            userIDs = tokenizer.nextToken();
            StringTokenizer idTokenizer = new StringTokenizer(userIDs, ",");
            String[] ids = new String[idTokenizer.countTokens()];
            int i = 0;
            while (idTokenizer.hasMoreTokens()) {
                ids[i++] = idTokenizer.nextToken();
            }
            String normalizedDN = GridMap.normalizeDN(globusID);
            GridMapEntry entry = (GridMapEntry)localMap.get(normalizedDN);
            if (entry == null) {
                entry = new GridMapEntry();
                entry.setGlobusID(globusID);
                entry.setUserIDs(ids);
                localMap.put(normalizedDN, entry);
                continue;
            }
            entry.addUserIDs(ids);
        }
        this.map = localMap;
    }

    public String getUserID(String globusID) {
        String[] ids = this.getUserIDs(globusID);
        if (ids != null && ids.length > 0) {
            return ids[0];
        }
        return null;
    }

    public String[] getUserIDs(String globusID) {
        if (globusID == null) {
            throw new IllegalArgumentException("globusID is null");
        }
        if (this.map == null) {
            return null;
        }
        GridMapEntry entry = (GridMapEntry)this.map.get(GridMap.normalizeDN(globusID));
        return entry == null ? null : entry.getUserIDs();
    }

    public boolean checkUser(String globusID, String userID) {
        if (globusID == null) {
            throw new IllegalArgumentException("globusID is null");
        }
        if (userID == null) {
            throw new IllegalArgumentException("userID is null");
        }
        if (this.map == null) {
            return false;
        }
        GridMapEntry entry = (GridMapEntry)this.map.get(GridMap.normalizeDN(globusID));
        return entry == null ? false : entry.containsUserID(userID);
    }

    public String getGlobusID(String userID) {
        if (userID == null) {
            throw new IllegalArgumentException("userID is null");
        }
        if (this.map == null) {
            return null;
        }
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry mapEntry = iter.next();
            GridMapEntry entry = (GridMapEntry)mapEntry.getValue();
            if (!entry.containsUserID(userID)) continue;
            return entry.getGlobusID();
        }
        return null;
    }

    public String[] getAllGlobusID(String userID) {
        if (userID == null) {
            throw new IllegalArgumentException("userID is null");
        }
        if (this.map == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry mapEntry = iter.next();
            GridMapEntry entry = (GridMapEntry)mapEntry.getValue();
            if (!entry.containsUserID(userID)) continue;
            v.add(entry.getGlobusID());
        }
        if (v.size() == 0) {
            return null;
        }
        String[] idS = new String[v.size()];
        for (int ctr = 0; ctr < v.size(); ++ctr) {
            idS[ctr] = (String)v.elementAt(ctr);
        }
        return idS;
    }

    public void map(String globusID, String userID) {
        String normalizedDN;
        GridMapEntry entry;
        if (globusID == null) {
            throw new IllegalArgumentException("globusID is null");
        }
        if (userID == null) {
            throw new IllegalArgumentException("userID is null");
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((entry = (GridMapEntry)this.map.get(normalizedDN = GridMap.normalizeDN(globusID))) == null) {
            entry = new GridMapEntry();
            entry.setGlobusID(globusID);
            entry.setUserIDs(new String[]{userID});
            this.map.put(normalizedDN, entry);
        } else {
            entry.addUserID(userID);
        }
    }

    private static boolean keyWordPresent(char[] args, int startIndex, char[] keyword, int length) {
        if (startIndex + length > args.length) {
            return false;
        }
        int j = startIndex;
        for (int i = 0; i < length; ++i) {
            if (args[j] != keyword[i]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static String normalizeDN(String globusID) {
        if (globusID == null) {
            return null;
        }
        globusID = globusID.toLowerCase();
        char[] globusIdChars = globusID.toCharArray();
        StringBuffer normalizedDN = new StringBuffer();
        int i = 0;
        while (i < globusIdChars.length) {
            if (globusIdChars[i] == '/') {
                normalizedDN.append("/");
                if (GridMap.keyWordPresent(globusIdChars, i + 1, EMAIL_KEYWORD_1, 2)) {
                    normalizedDN.append(EMAIL_KEYWORD);
                    i += 2;
                } else if (GridMap.keyWordPresent(globusIdChars, i + 1, EMAIL_KEYWORD_2, 6)) {
                    normalizedDN.append(EMAIL_KEYWORD);
                    i += 6;
                } else if (GridMap.keyWordPresent(globusIdChars, i + 1, UID_KEYWORD, 4)) {
                    normalizedDN.append(USERID_KEYWORD);
                    i += 4;
                }
                ++i;
                continue;
            }
            normalizedDN.append(globusIdChars[i]);
            ++i;
        }
        return normalizedDN.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class GridMapEntry
    implements Serializable {
        String globusID;
        String[] userIDs;

        GridMapEntry() {
        }

        public String getFirstUserID() {
            return this.userIDs[0];
        }

        public String[] getUserIDs() {
            return this.userIDs;
        }

        public String getGlobusID() {
            return this.globusID;
        }

        public void setGlobusID(String globusID) {
            this.globusID = globusID;
        }

        public void setUserIDs(String[] userIDs) {
            this.userIDs = userIDs;
        }

        public boolean containsUserID(String userID) {
            if (userID == null) {
                return false;
            }
            for (int i = 0; i < this.userIDs.length; ++i) {
                if (!this.userIDs[i].equalsIgnoreCase(userID)) continue;
                return true;
            }
            return false;
        }

        public void addUserID(String userID) {
            if (this.containsUserID(userID)) {
                return;
            }
            String[] ids = new String[this.userIDs.length + 1];
            System.arraycopy(this.userIDs, 0, ids, 0, this.userIDs.length);
            ids[this.userIDs.length] = userID;
            this.userIDs = ids;
        }

        public void addUserIDs(String[] userIDs) {
            for (int i = 0; i < userIDs.length; ++i) {
                this.addUserID(userIDs[i]);
            }
        }
    }
}

