/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.globus.common.CoGProperties;
import org.globus.common.Version;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.TrustedCertificates;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.gsi.proxy.ProxyPathValidatorException;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.gsi.proxy.ext.ProxyCertInfo;
import org.globus.gsi.proxy.ext.ProxyPolicy;
import org.globus.tools.DefaultProxyInit;
import org.globus.util.Util;

public abstract class ProxyInit {
    public static final String GENERIC_POLICY_OID = "1.3.6.1.4.1.3536.1.1.1.8";
    private static final String message = "\nSyntax: java ProxyInit [options]\n        java ProxyInit -help\n\n    Options:\n    -help | -usage\t\tDisplays usage.\n    -version\t\t\tDisplays version.\n    -debug\t\t\tEnables extra debug output.\n    -verify\t\t\tPerforms proxy verification tests (default).\n    -pwstdin\t\t\tAllows passphrase from stdin.\n    -noverify\t\t\tDisables proxy verification tests.\n    -quiet | -q\t\t\tQuiet mode, minimal output\n    -limited\t\t\tCreates a limited proxy.\n    -independent\t\tCreates a independent globus proxy.\n    -old\t\t\tCreates a legacy globus proxy.\n    -hours <hours>\t\tProxy is valid for H hours (default:12).\n    -bits <bits>\t\tNumber of bits in key {512|1024|2048|4096}.\n    -globus\t\t\tPrints user identity in globus format.\n    -policy <policyfile>\tFile containing policy to store in the\n                        \tProxyCertInfo extension\n    -pl <oid>\t\t\tOID string for the policy language.\n    -policy-language <oid>\tused in the policy file.\n    -path-length <l>\t\tAllow a chain of at most l proxies to be \n                    \t\tgenerated from this one\n    -cert <certfile>\t\tNon-standard location of user certificate\n    -key <keyfile>\t\tNon-standard location of user key\n    -out <proxyfile>\t\tNon-standard location of new proxy cert.\n    -pkcs11\t\t\tEnables the PKCS11 support module. The\n           \t\t\t-cert and -key arguments are used as labels\n           \t\t\tto find the credentials on the device.\n    -rfc\t\t\tCreates RFC 820 compliant proxy\n";
    protected X509Certificate[] certificates;
    protected int bits = 512;
    protected int lifetime = 43200;
    protected ProxyCertInfo proxyCertInfo = null;
    protected int proxyType;
    protected boolean quiet = false;
    protected boolean debug = false;
    protected boolean stdin = false;
    protected GlobusCredential proxy = null;

    public abstract void init(String[] var1);

    public abstract void loadCertificates(String var1);

    public abstract void loadKey(String var1);

    public abstract void sign();

    public X509Certificate getCertificate() {
        return this.certificates[0];
    }

    public void dispose() {
    }

    public void verify() throws Exception {
        TrustedCertificates trustedCerts = TrustedCertificates.getDefaultTrustedCertificates();
        if (trustedCerts == null || trustedCerts.getCertificates() == null || trustedCerts.getCertificates().length == 0) {
            throw new Exception("Unable to load CA ceritificates");
        }
        ProxyPathValidator validator = new ProxyPathValidator();
        if (this.proxyCertInfo != null) {
            String oid = this.proxyCertInfo.getProxyPolicy().getPolicyLanguage().getId();
            validator.setProxyPolicyHandler(oid, new ProxyPolicyHandler(){

                public void validate(ProxyCertInfo proxyCertInfo, X509Certificate[] certPath, int index) throws ProxyPathValidatorException {
                    System.out.println("Proxy verify: Ignoring proxy policy");
                    if (ProxyInit.this.debug) {
                        String policy = new String(proxyCertInfo.getProxyPolicy().getPolicy());
                        System.out.println("Policy:");
                        System.out.println(policy);
                    }
                }
            });
        }
        validator.validate(this.proxy.getCertificateChain(), trustedCerts.getCertificates());
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public void setProxyType(int proxyType) {
        this.proxyType = proxyType;
    }

    public void setProxyCertInfo(ProxyCertInfo proxyCertInfo) {
        this.proxyCertInfo = proxyCertInfo;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setStdin(boolean stdin) {
        this.stdin = stdin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void createProxy(String cert, String key, boolean verify, boolean globusStyle, String proxyFile) {
        block21: {
            this.init(new String[]{cert, key});
            this.loadCertificates(cert);
            if (!this.quiet) {
                dn = null;
                dn = globusStyle != false ? CertUtil.toGlobusID(this.getCertificate().getSubjectDN()) : this.getCertificate().getSubjectDN().getName();
                System.out.println("Your identity: " + dn);
            }
            this.loadKey(key);
            if (this.debug) {
                System.out.println("Using " + this.bits + " bits for private key");
            }
            if (!this.quiet) {
                System.out.println("Creating proxy, please wait...");
            }
            this.sign();
            if (verify) {
                try {
                    this.verify();
                    System.out.println("Proxy verify OK");
                }
                catch (Exception e) {
                    System.out.println("Proxy verify failed: " + e.getMessage());
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    System.exit(-1);
                }
            }
            if (this.debug) {
                System.out.println("Saving proxy to: " + proxyFile);
            }
            if (!this.quiet) {
                System.out.println("Your proxy is valid until " + this.proxy.getCertificateChain()[0].getNotAfter());
            }
            out = null;
            try {
                file = Util.createFile(proxyFile);
                if (!Util.setOwnerAccessOnly(proxyFile)) {
                    System.err.println("Warning: Please check file permissions for your proxy file.");
                }
                out = new FileOutputStream(file);
                this.proxy.save(out);
                var9_10 = null;
                ** if (out == null) goto lbl-1000
            }
            catch (Throwable var8_16) {
                var9_12 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                throw var8_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block21;
                catch (IOException e) {
                    System.err.println("Failed to save proxy to a file: " + e.getMessage());
                    System.exit(-1);
                    var9_11 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        this.dispose();
    }

    public static void main(String[] args) {
        boolean restricted;
        int bits = 512;
        int lifetime = 43200;
        boolean debug = false;
        boolean quiet = false;
        boolean verify = true;
        boolean pkcs11 = false;
        boolean limited = false;
        int pathLen = -1;
        int proxyType = -1;
        int oid = 1;
        String policyLanguage = null;
        String policyFile = null;
        boolean stdin = false;
        boolean independent = false;
        CoGProperties properties = CoGProperties.getDefault();
        boolean globusStyle = false;
        String proxyFile = properties.getProxyFile();
        String keyFile = null;
        String certFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-hours")) {
                if (i + 1 >= args.length) {
                    ProxyInit.argError("-hours argument missing");
                }
                lifetime = 3600 * Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-bits")) {
                if (i + 1 >= args.length) {
                    ProxyInit.argError("-bits argument missing");
                }
                bits = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-pwstdin")) {
                stdin = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-limited")) {
                limited = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-independent")) {
                independent = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-old")) {
                oid = 0;
                continue;
            }
            if (args[i].equalsIgnoreCase("-path-length")) {
                if (i + 1 >= args.length) {
                    ProxyInit.argError("-path-length argument missing");
                }
                pathLen = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-pl") || args[i].equalsIgnoreCase("-policy-language")) {
                if (i + 1 >= args.length) {
                    ProxyInit.argError("-policy-language argument missing");
                }
                policyLanguage = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-policy")) {
                if (i + 1 >= args.length) {
                    ProxyInit.argError("-policy argument missing");
                }
                policyFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-verify")) {
                verify = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-noverify")) {
                verify = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-out")) {
                if (i + 1 >= args.length) {
                    ProxyInit.argError("-out argument missing");
                }
                proxyFile = args[++i];
                continue;
            }
            if (args[i].equals("-q") || args[i].equalsIgnoreCase("-quiet")) {
                quiet = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-globus")) {
                globusStyle = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-pkcs11")) {
                pkcs11 = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-key")) {
                if (i + 1 >= args.length) {
                    ProxyInit.argError("-key argument missing");
                }
                keyFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-cert")) {
                if (i + 1 >= args.length) {
                    ProxyInit.argError("-cert argument missing");
                }
                certFile = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-valid")) {
                lifetime = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-version")) {
                System.err.println(Version.getVersion());
                System.exit(1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(message);
                System.exit(1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-rfc")) {
                oid = 2;
                continue;
            }
            ProxyInit.argError("Argument not recognized: " + args[i]);
            break;
        }
        if (proxyFile == null) {
            ProxyInit.error("Proxy file not specified.");
        }
        boolean bl = restricted = policyFile != null || policyLanguage != null;
        if (independent) {
            if (oid == 0) {
                ProxyInit.error("-old and -independent are exclusive");
            }
            if (limited) {
                ProxyInit.error("-limited and -independent are exclusive");
            }
            if (restricted) {
                ProxyInit.error("-indepedent and -policy or -pl are exclusive");
            }
            proxyType = oid == 1 ? 13 : 17;
        }
        if (restricted) {
            if (oid == 0) {
                ProxyInit.error("-old and -policy or -pl are exclusive");
            }
            if (limited) {
                ProxyInit.error("-limited and -policy or -pl are exclusive");
            }
            proxyType = oid == 1 ? 12 : 16;
        }
        if (proxyType == -1) {
            proxyType = oid == 1 ? (limited ? 15 : 14) : (oid == 2 ? (limited ? 19 : 18) : (limited ? 11 : 10));
        }
        ProxyInit init = null;
        if (pkcs11) {
            if (keyFile == null) {
                keyFile = certFile == null ? (certFile = properties.getDefaultPKCS11Handle()) : certFile;
            } else if (certFile == null) {
                certFile = keyFile;
            }
            try {
                Class<?> iClass = Class.forName("org.globus.pkcs11.tools.PKCS11ProxyInit");
                init = (ProxyInit)iClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                System.err.println("Error: Failed to load PKCS11 module.");
                System.exit(-1);
            }
            catch (InstantiationException e) {
                System.err.println("Error: Failed to instantiate PKCS11 module: " + e.getMessage());
                System.exit(-1);
            }
            catch (IllegalAccessException e) {
                System.err.println("Error: Failed to initialize PKCS11 module: " + e.getMessage());
                System.exit(-1);
            }
        } else {
            if (keyFile == null) {
                keyFile = properties.getUserKeyFile();
            }
            if (certFile == null) {
                certFile = properties.getUserCertFile();
            }
            init = new DefaultProxyInit();
        }
        if (debug) {
            System.err.println("Files used: ");
            System.err.println("  proxy     : " + (proxyFile == null ? "none" : proxyFile));
            System.err.println("  user key  : " + (keyFile == null ? "none" : keyFile));
            System.err.println("  user cert : " + (certFile == null ? "none" : certFile));
        }
        CertUtil.init();
        ProxyCertInfo proxyCertInfo = null;
        if (CertUtil.isGsi3Proxy(proxyType) || CertUtil.isGsi4Proxy(proxyType)) {
            ProxyPolicy policy = null;
            if (CertUtil.isLimitedProxy(proxyType)) {
                policy = new ProxyPolicy(ProxyPolicy.LIMITED);
            } else if (CertUtil.isIndependentProxy(proxyType)) {
                policy = new ProxyPolicy(ProxyPolicy.INDEPENDENT);
            } else if (CertUtil.isImpersonationProxy(proxyType)) {
                policy = new ProxyPolicy(ProxyPolicy.IMPERSONATION);
            } else if (proxyType == 12 || proxyType == 16) {
                if (policyFile == null) {
                    ProxyInit.error("Policy file required.");
                }
                if (policyLanguage == null) {
                    policyLanguage = GENERIC_POLICY_OID;
                }
                byte[] policyData = null;
                try {
                    policyData = ProxyInit.readPolicyFile(policyFile);
                }
                catch (IOException e) {
                    ProxyInit.error("Failed to load policy file: " + e.getMessage());
                }
                policy = new ProxyPolicy(policyLanguage, policyData);
            } else {
                throw new IllegalArgumentException("Invalid proxyType");
            }
            proxyCertInfo = pathLen >= 0 ? new ProxyCertInfo(pathLen, policy) : new ProxyCertInfo(policy);
        }
        init.setBits(bits);
        init.setLifetime(lifetime);
        init.setProxyType(proxyType);
        init.setProxyCertInfo(proxyCertInfo);
        init.setDebug(debug);
        init.setQuiet(quiet);
        init.setStdin(stdin);
        init.createProxy(certFile, keyFile, verify, globusStyle, proxyFile);
    }

    private static void argError(String error) {
        System.err.println("Error: " + error);
        System.err.println();
        System.err.println("Usage: java ProxyInit [-help][-limited][-hours H] ...");
        System.err.println();
        System.err.println("Use -help to display full usage");
        System.exit(1);
    }

    protected static void error(String error) {
        System.err.println("Error: " + error);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readPolicyFile(String file) throws IOException {
        File f = new File(file);
        FileInputStream in = new FileInputStream(f);
        byte[] data = new byte[(int)f.length()];
        int off = 0;
        int bytes = 0;
        try {
            for (int left = data.length; left > 0; left -= bytes) {
                bytes = in.read(data, off, left);
                if (bytes == -1) {
                    throw new EOFException();
                }
                off += bytes;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return data;
    }
}

