/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.client;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.utils.Resources;

public class ServiceURL {
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    public static final String DEFAULT_SERVICE_CONTEXT = "wsrf/services/";
    private String contactString;
    private String serviceName;
    private URL url;
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static final String URL_SEPARATOR = "://";
    private static Log logger = LogFactory.getLog((String)ServiceURL.class.getName());

    public ServiceURL(String contactString) {
        if (contactString == null) {
            contactString = ServiceURL.getDefaultHost();
        } else if (contactString.endsWith("/")) {
            contactString = contactString.substring(0, contactString.length() - 1);
        }
        this.contactString = contactString;
    }

    public ServiceURL(String contactString, String serviceName) {
        this(contactString);
        this.setServiceName(serviceName);
    }

    public static URL getURL(String contactString, String serviceName) throws MalformedURLException {
        URL url = null;
        ServiceURL serviceURL = new ServiceURL(contactString, serviceName);
        url = serviceURL.getURL();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolved contact string to URL:" + url.toExternalForm()));
        }
        return url;
    }

    public String getFullServicePath() {
        return "/wsrf/services/" + this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public URL getURL() throws MalformedURLException {
        if (this.url == null) {
            String contactURLString = this.contactString;
            if (this.contactString.indexOf(URL_SEPARATOR) == -1) {
                contactURLString = ServiceURL.getDefaultProtocol() + URL_SEPARATOR + this.contactString;
            }
            this.url = new URL(contactURLString);
            String protocol = this.url.getProtocol();
            String host = this.url.getHost();
            int port = this.url.getPort();
            String path = this.url.getPath();
            if (host.equals("")) {
                host = ServiceURL.getDefaultHost();
            }
            if (port == -1) {
                port = protocol.equals("http") ? 80 : (protocol.equals("https") ? 443 : ServiceURL.getDefaultPort());
            }
            if (path.equals("")) {
                if (this.serviceName != null && !this.serviceName.equals("")) {
                    path = this.getFullServicePath();
                } else {
                    throw new RuntimeException(i18n.getMessage("noServiceName"));
                }
            }
            this.url = new URL(protocol, host, port, path);
        }
        return this.url;
    }

    public static String getDefaultProtocol() {
        return ServiceHost.getDefaultProtocol();
    }

    public static String getDefaultHost() {
        String defaultHost;
        try {
            defaultHost = ServiceHost.getDefaultHost();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            try {
                InetAddress ipAddress = InetAddress.getLocalHost();
                defaultHost = ipAddress.getHostName();
            }
            catch (Exception iNetEx) {
                logger.error((Object)"", (Throwable)iNetEx);
                throw new RuntimeException(iNetEx.getMessage());
            }
        }
        return defaultHost;
    }

    public static int getDefaultPort() {
        return ServiceHost.getDefaultPort();
    }
}

