/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.container.ContainerException;
import org.globus.wsrf.container.ServiceContainer;
import org.globus.wsrf.utils.Resources;

public class ServiceContainerCollection {
    private static Hashtable containers = new Hashtable();
    static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    static Log logger = LogFactory.getLog((String)ServiceContainerCollection.class.getName());

    public static void register(String name, ServiceContainer container) {
        containers.put(name, container);
    }

    public static void unregister(String name) {
        containers.remove(name);
    }

    public static ServiceContainer get(String name) {
        return (ServiceContainer)containers.get(name);
    }

    public static void stopAll(boolean force) throws ContainerException {
        Enumeration e = containers.elements();
        while (e.hasMoreElements()) {
            ServiceContainer container = (ServiceContainer)e.nextElement();
            if (force) {
                try {
                    container.close();
                    continue;
                }
                catch (IOException ex) {
                    throw new ContainerException(i18n.getMessage("containerStopError"), ex);
                }
            }
            container.stop();
        }
    }

    public static class ShutdownThread
    extends Thread {
        public void run() {
            try {
                ServiceContainerCollection.stopAll(true);
            }
            catch (Exception e) {
                logger.debug((Object)i18n.getMessage("shutdownFailure"), (Throwable)e);
            }
        }
    }
}

