/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.encoding;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.DeserializationContext;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.DeserializerImpl;
import org.apache.axis.encoding.Target;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.message.SOAPHandler;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.utils.Resources;
import org.oasis.DialectDependentType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class DialectDependentDeserializer
extends DeserializerImpl {
    static Log logger = LogFactory.getLog((String)DialectDependentDeserializer.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    protected Map deserializerFactories = new HashMap();
    protected QName attributeName;
    protected String typeMappingName;
    protected Class javaType;
    protected boolean failOnError = true;

    public void registerDeserializerFactory(URI dialect, DeserializerFactory deserializerFactory) {
        this.deserializerFactories.put(dialect, deserializerFactory);
    }

    public void unregisterDeserializerFactory(URI dialect) {
        this.deserializerFactories.remove(dialect);
    }

    public void onStartElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        QName xmlType;
        TypeMapping tm;
        URI dialect = null;
        try {
            this.value = this.javaType.newInstance();
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getLocalName(i).equals(this.attributeName.getLocalPart()) || !attributes.getURI(i).equals("") && !attributes.getURI(i).equals(this.attributeName.getNamespaceURI())) continue;
                dialect = new URI(attributes.getValue(i));
                ((DialectDependentType)this.value).setDialect(dialect);
                break;
            }
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
        DeserializerFactory factory = (DeserializerFactory)this.deserializerFactories.get(dialect);
        if (factory == null && (factory = (DeserializerFactory)(tm = context.getTypeMapping()).getDeserializer(xmlType = new QName(dialect.toString(), this.typeMappingName))) == null) {
            if (this.failOnError) {
                throw new SAXException(i18n.getMessage("noDialectDeserializer", (Object)dialect));
            }
            return;
        }
        SOAPHandler dialectDeserializer = (SOAPHandler)factory.getDeserializerAs("Axis SAX Mechanism");
        ((Deserializer)dialectDeserializer).registerValueTarget((Target)new DialectTarget());
        this.isEnded = true;
        this.valueComplete();
        context.replaceElementHandler(dialectDeserializer);
        dialectDeserializer.startElement(namespace, localName, prefix, attributes, context);
    }

    private class DialectTarget
    implements Target {
        private DialectTarget() {
        }

        public void set(Object obj) throws SAXException {
            ((DialectDependentType)DialectDependentDeserializer.this.value).setValue(obj);
        }
    }
}

