/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.jndi;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.apache.axis.AxisEngine;
import org.apache.axis.MessageContext;
import org.apache.axis.server.AxisServer;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.wsrf.container.ServiceManager;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityConfig;
import org.globus.wsrf.jndi.BasicBeanFactory;
import org.globus.wsrf.jndi.ServiceResourceRef;
import org.globus.wsrf.security.SecurityManager;

public class BeanFactory
extends BasicBeanFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        Subject subject = null;
        MessageContext msgCtx = null;
        if (obj instanceof ServiceResourceRef) {
            ServiceResourceRef resource = (ServiceResourceRef)((Object)obj);
            AxisEngine engine = resource.getAxisEngine();
            String serviceName = resource.getServiceName();
            if (engine == null) {
                throw new NamingException(i18n.getMessage("noServiceSet"));
            }
            if (serviceName == null) {
                throw new NamingException(i18n.getMessage("noEngineSet"));
            }
            ServiceManager serviceManager = ServiceManager.getServiceManager((AxisServer)engine);
            SecurityManager securityManager = SecurityManager.getManager();
            try {
                msgCtx = serviceManager.createMessageContext(serviceName);
                ServiceSecurityConfig.initialize(msgCtx);
                subject = securityManager.getServiceSubject(serviceName);
            }
            catch (Exception e) {
                NamingException ne = new NamingException(i18n.getMessage("beanSecInitFailed"));
                ne.setRootCause(e);
                throw ne;
            }
        }
        try {
            if (subject == null) {
                return this.getInstance(msgCtx, obj, name, nameCtx, environment);
            }
            GetInstanceAction action = new GetInstanceAction(msgCtx, obj, name, nameCtx, environment);
            return JaasSubject.doAs(subject, (PrivilegedExceptionAction)action);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (PrivilegedActionException e) {
            Exception cause = e.getException();
            if (cause instanceof NamingException) {
                throw (NamingException)cause;
            }
            NamingException nm = new NamingException(i18n.getMessage("beanInitFailed"));
            nm.setRootCause(cause);
            throw nm;
        }
        catch (Exception e) {
            NamingException nm = new NamingException(i18n.getMessage("beanInitFailed"));
            nm.setRootCause(e);
            throw nm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getInstance(MessageContext msgCtx, Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        MessageContext oldCtx = ServiceManager.HelperAxisEngine.getCurrentMessageContext();
        ServiceManager.HelperAxisEngine.setCurrentMessageContext(msgCtx);
        try {
            Object object = super.getObjectInstance(obj, name, nameCtx, environment);
            return object;
        }
        finally {
            ServiceManager.HelperAxisEngine.setCurrentMessageContext(oldCtx);
        }
    }

    private class GetInstanceAction
    implements PrivilegedExceptionAction {
        private MessageContext msgCtx;
        private Object obj;
        private Name name;
        private Context nameCtx;
        private Hashtable environment;

        private GetInstanceAction(MessageContext msgCtx, Object obj, Name name, Context nameCtx, Hashtable environment) {
            this.msgCtx = msgCtx;
            this.obj = obj;
            this.name = name;
            this.nameCtx = nameCtx;
            this.environment = environment;
        }

        public Object run() throws Exception {
            return BeanFactory.this.getInstance(this.msgCtx, this.obj, this.name, this.nameCtx, this.environment);
        }
    }
}

