/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.jndi;

import java.util.Iterator;
import java.util.Set;
import javax.naming.Context;
import javax.naming.LinkRef;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.apache.axis.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.naming.ResourceRef;
import org.globus.util.I18n;
import org.globus.wsrf.jndi.JNDIUtils;
import org.globus.wsrf.jndi.ServiceResourceRef;
import org.globus.wsrf.tools.jndi.ConfigContext;
import org.globus.wsrf.tools.jndi.Environment;
import org.globus.wsrf.tools.jndi.Resource;
import org.globus.wsrf.tools.jndi.ResourceLink;
import org.globus.wsrf.tools.jndi.ResourceParameters;
import org.globus.wsrf.utils.Resources;

public class NamingContext {
    private static Log logger = LogFactory.getLog((String)NamingContext.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    private Context context;
    private AxisEngine engine;

    public NamingContext(Context context, AxisEngine engine) {
        this.context = context;
        this.engine = engine;
    }

    public void addEnvironment(Environment environment) throws IllegalArgumentException, NamingException {
        Object value;
        block14: {
            value = null;
            String type = environment.getType();
            try {
                if (type.equals("java.lang.String")) {
                    value = environment.getValue();
                    break block14;
                }
                if (type.equals("java.lang.Byte")) {
                    value = environment.getValue() == null ? new Byte(0) : Byte.decode(environment.getValue());
                    break block14;
                }
                if (type.equals("java.lang.Short")) {
                    value = environment.getValue() == null ? new Short(0) : Short.decode(environment.getValue());
                    break block14;
                }
                if (type.equals("java.lang.Integer")) {
                    value = environment.getValue() == null ? new Integer(0) : Integer.decode(environment.getValue());
                    break block14;
                }
                if (type.equals("java.lang.Long")) {
                    value = environment.getValue() == null ? new Long(0L) : Long.decode(environment.getValue());
                    break block14;
                }
                if (type.equals("java.lang.Boolean")) {
                    value = Boolean.valueOf(environment.getValue());
                    break block14;
                }
                if (type.equals("java.lang.Double")) {
                    value = environment.getValue() == null ? new Double(0.0) : Double.valueOf(environment.getValue());
                    break block14;
                }
                if (type.equals("java.lang.Float")) {
                    value = environment.getValue() == null ? new Float(0.0f) : Float.valueOf(environment.getValue());
                    break block14;
                }
                if (type.equals("java.lang.Character")) {
                    if (environment.getValue() == null) {
                        value = new Character('\u0000');
                        break block14;
                    }
                    if (environment.getValue().length() == 1) {
                        value = new Character(environment.getValue().charAt(0));
                        break block14;
                    }
                    throw new IllegalArgumentException();
                }
                throw new IllegalArgumentException(i18n.getMessage("invalidType", (Object)type));
            }
            catch (NumberFormatException e) {
                String msg = i18n.getMessage("invalidValueForType", new Object[]{environment.getValue(), type});
                logger.error((Object)msg, (Throwable)e);
                throw new IllegalArgumentException(msg);
            }
        }
        this.createSubcontexts(environment.getName());
        this.context.bind(environment.getName(), value);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added environment entry with name: " + environment.getName()));
            logger.debug((Object)("value: " + value + " and type: " + environment.getType()));
        }
    }

    public void addResource(Resource resource) throws NamingException {
        ResourceRef reference = new ResourceRef(resource.getType(), resource.getDescription(), resource.getScope(), resource.getAuth());
        this.addParameters((Reference)reference, resource.getParameters());
        this.createSubcontexts(resource.getName());
        this.context.bind(resource.getName(), (Object)reference);
        logger.debug((Object)("Added resource entry with name: " + resource.getName()));
    }

    public void addServiceResource(Resource resource, String serviceName) throws NamingException {
        ServiceResourceRef reference = new ServiceResourceRef(resource.getType(), resource.getDescription(), resource.getScope(), resource.getAuth(), this.engine, serviceName);
        this.addParameters((Reference)((Object)reference), resource.getParameters());
        this.createSubcontexts(resource.getName());
        this.context.bind(resource.getName(), (Object)reference);
        logger.debug((Object)("Added service resource entry with name: " + resource.getName()));
    }

    public void addResourceLink(ResourceLink resourceLink) throws NamingException {
        LinkRef link = new LinkRef(resourceLink.getTarget());
        this.createSubcontexts(resourceLink.getName());
        this.context.bind(resourceLink.getName(), (Object)link);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added resource link with name: " + resourceLink.getName()));
            logger.debug((Object)("Pointing to: " + resourceLink.getTarget()));
        }
    }

    public void addSubContext(ConfigContext subContext) throws NamingException {
        this.addService(subContext);
    }

    public void addService(ConfigContext subContext) throws NamingException {
        NamingContext newContext;
        String serviceName = subContext.getName();
        Context servicesContext = null;
        try {
            servicesContext = (Context)this.context.lookup("services");
        }
        catch (NameNotFoundException e) {
            servicesContext = this.context.createSubcontext("services");
        }
        JNDIUtils.createSubcontexts(servicesContext, serviceName);
        try {
            newContext = new NamingContext(servicesContext.createSubcontext(serviceName), this.engine);
            logger.debug((Object)("Created new subcontext with name: " + serviceName));
        }
        catch (Exception e) {
            newContext = new NamingContext((Context)servicesContext.lookup(serviceName), this.engine);
            logger.debug((Object)("Adding entries to existing subcontext with name: " + serviceName));
        }
        Set names = subContext.getEnvironmentNames();
        Iterator nameIterator = names.iterator();
        while (nameIterator.hasNext()) {
            newContext.addEnvironment(subContext.getEnvironment((String)nameIterator.next()));
        }
        names = subContext.getResourceNames();
        nameIterator = names.iterator();
        while (nameIterator.hasNext()) {
            newContext.addServiceResource(subContext.getResource((String)nameIterator.next()), serviceName);
        }
        names = subContext.getResourceLinkNames();
        nameIterator = names.iterator();
        while (nameIterator.hasNext()) {
            newContext.addResourceLink(subContext.getResourceLink((String)nameIterator.next()));
        }
    }

    private void createSubcontexts(String name) throws NamingException {
        JNDIUtils.createSubcontexts(this.context, name);
    }

    private void addParameters(Reference reference, ResourceParameters parameters) {
        if (parameters != null) {
            Set names = parameters.getParameterNames();
            Iterator nameIterator = names.iterator();
            while (nameIterator.hasNext()) {
                String parameterName = (String)nameIterator.next();
                StringRefAddr parameter = new StringRefAddr(parameterName, parameters.getParameter(parameterName));
                reference.add(parameter);
            }
        }
    }
}

