/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.utils;

import java.net.URL;
import javax.xml.soap.SOAPElement;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.Resources;

public class AddressingUtils {
    static Log logger = LogFactory.getLog((String)AddressingUtils.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());

    public static EndpointReferenceType createEndpointReference(String address, ResourceKey key) throws Exception {
        EndpointReferenceType reference = new EndpointReferenceType();
        if (key != null) {
            ReferencePropertiesType referenceProperties = new ReferencePropertiesType();
            SOAPElement elem = key.toSOAPElement();
            AnyHelper.setAny((AnyContentType)referenceProperties, elem);
            reference.setProperties(referenceProperties);
        }
        reference.setAddress((AttributedURI)new Address(address));
        return reference;
    }

    public static EndpointReferenceType createEndpointReference(ResourceKey key) throws Exception {
        return AddressingUtils.createEndpointReference(ResourceContext.getResourceContext(), key);
    }

    public static EndpointReferenceType createEndpointReference(ResourceContext context, ResourceKey key) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"context"));
        }
        URL baseURL = ServiceHost.getBaseURL();
        String serviceURI = baseURL.toString() + context.getService();
        return AddressingUtils.createEndpointReference(serviceURI, key);
    }
}

