/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.providers;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.providers.GSSKey;
import org.ietf.jgss.GSSContext;

public class GSSCipher
extends CipherSpi {
    private int mode;
    private GSSContext context = null;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$providers$GSSCipher == null ? (class$org$globus$wsrf$providers$GSSCipher = GSSCipher.class$("org.globus.wsrf.providers.GSSCipher")) : class$org$globus$wsrf$providers$GSSCipher).getName());
    static /* synthetic */ Class class$org$globus$wsrf$providers$GSSCipher;

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected int engineGetKeySize(Key key) {
        return 0;
    }

    protected int engineGetOutputSize(int inputLen) {
        return 0;
    }

    protected byte[] engineGetIV() {
        return new byte[0];
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof GSSKey)) {
            throw new InvalidKeyException();
        }
        this.mode = opmode;
        this.context = ((GSSKey)key).getContext();
        logger.debug((Object)"init called");
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(opmode, key, random);
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return null;
    }

    protected int engineUpdate(byte[] input, int inputOffset) throws ShortBufferException {
        throw new ShortBufferException("Not supported");
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        if (this.context == null) {
            throw new IllegalBlockSizeException("No GSS context");
        }
        if (this.mode == 1) {
            try {
                byte[] wrapres = this.context.wrap(input, inputOffset, inputLen, null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("wrap input = " + inputLen + " bytes output = " + wrapres.length + " bytes"));
                }
                return wrapres;
            }
            catch (Exception e) {
                throw new IllegalBlockSizeException("Could not wrap data: " + e);
            }
        }
        if (this.mode == 2) {
            try {
                byte[] wrapres = this.context.unwrap(input, inputOffset, inputLen, null);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("unwrap input = " + inputLen + " bytes output = " + wrapres.length + " bytes"));
                }
                return wrapres;
            }
            catch (Exception e) {
                throw new IllegalBlockSizeException("Could not unwrap data: " + e);
            }
        }
        throw new IllegalBlockSizeException("Unsupported Mode");
    }

    protected int engineDoFinal(byte[] input, int inputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        throw new ShortBufferException("Not supported");
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        throw new ShortBufferException("Not supported");
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        throw new ShortBufferException("Not supported");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

