/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.index.impl;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.aggregator.impl.AggregatorUtils;
import org.globus.mds.index.SimpleRegConfig;
import org.globus.mds.index.impl.IndexService;
import org.globus.mds.servicegroup.client.ServiceGroupRegistrationParameters;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.impl.servicegroup.client.ServiceGroupRegistrationClient;
import org.globus.wsrf.utils.AddressingUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultIndexService
extends IndexService {
    static final Log logger = LogFactory.getLog((Class)(class$org$globus$mds$index$impl$DefaultIndexService == null ? (class$org$globus$mds$index$impl$DefaultIndexService = DefaultIndexService.class$("org.globus.mds.index.impl.DefaultIndexService")) : class$org$globus$mds$index$impl$DefaultIndexService));
    private Hashtable upstreamTable = new Hashtable();
    private Hashtable downstreamTable = new Hashtable();
    private String configDirPath;
    private String registrationFilePath;
    private String skeletonUpstreamRegistrationPath;
    private String skeletonDownstreamRegistrationPath;
    private EndpointReferenceType localEpr = null;
    static final int REG_DELAY = 8000;
    static /* synthetic */ Class class$org$globus$mds$index$impl$DefaultIndexService;
    static /* synthetic */ Class class$org$globus$mds$index$SimpleRegConfig;

    public DefaultIndexService() {
        String baseDir = DefaultIndexService.getBaseDirectory();
        this.configDirPath = baseDir + "/etc/globus_wsrf_mds_index/";
        this.registrationFilePath = this.configDirPath + "hierarchy.xml";
        this.skeletonUpstreamRegistrationPath = this.configDirPath + "upstream.xml";
        this.skeletonDownstreamRegistrationPath = this.configDirPath + "downstream.xml";
        this.processConfigFile();
        this.performDefaultRegistrations();
    }

    private static String getBaseDirectory() {
        return ContainerConfig.getBaseDirectory();
    }

    void processConfigFile() {
        SimpleRegConfig config;
        try {
            this.localEpr = AddressingUtils.createEndpointReference(null);
        }
        catch (Exception e) {
            logger.error((Object)("Fatal error when getting local service EPR: " + e));
            return;
        }
        logger.info((Object)("Reading default registration configuration from file: " + this.registrationFilePath));
        try {
            config = this.readConfig(this.registrationFilePath);
        }
        catch (Exception e) {
            logger.warn((Object)("Could not read default index config: " + e));
            return;
        }
        String[] downstream = config.getDownstream();
        for (int i = 0; downstream != null && i < downstream.length; ++i) {
            String entry = downstream[i].trim();
            this.downstreamTable.put(entry, entry);
        }
        String[] upstream = config.getUpstream();
        for (int i = 0; upstream != null && i < upstream.length; ++i) {
            String entry = upstream[i].trim();
            this.upstreamTable.put(entry, entry);
        }
    }

    void performDefaultRegistrations() {
        ServiceGroupRegistrationClient client = ServiceGroupRegistrationClient.getContainerClient();
        String downstreamEntry = null;
        Enumeration downstreamEntries = this.downstreamTable.elements();
        while (downstreamEntries.hasMoreElements()) {
            downstreamEntry = (String)downstreamEntries.nextElement();
            logger.info((Object)("Processing downstream registration to " + downstreamEntry));
            try {
                ServiceGroupRegistrationParameters params = ServiceGroupRegistrationClient.readParams((String)this.skeletonDownstreamRegistrationPath);
                EndpointReferenceType epr = new EndpointReferenceType();
                epr.setAddress((AttributedURI)new Address(downstreamEntry));
                String dup = (String)this.upstreamTable.get(downstreamEntry);
                if (dup != null) {
                    logger.warn((Object)("Check configuration - a matching upstream registration was found for a downstream registration for this address: " + downstreamEntry));
                }
                if (AggregatorUtils.detectLoopback((EndpointReferenceType)epr, (EndpointReferenceType)this.localEpr)) {
                    logger.warn((Object)("Check configuration - loopback condition detected in downstream registration - check configuration: Registrant EPR was: [" + epr.getAddress() + "] Local EPR was: [" + this.localEpr.getAddress() + "]"));
                }
                params.setRegistrantEPR(epr);
                client.register(params, 8000L);
            }
            catch (Exception e) {
                logger.error((Object)("When registering a downstream service: " + e));
            }
        }
        String upstreamEntry = null;
        Enumeration upstreamEntries = this.upstreamTable.elements();
        while (upstreamEntries.hasMoreElements()) {
            upstreamEntry = (String)upstreamEntries.nextElement();
            logger.info((Object)("Processing upstream registration to " + upstreamEntry));
            try {
                ServiceGroupRegistrationParameters params = ServiceGroupRegistrationClient.readParams((String)this.skeletonUpstreamRegistrationPath);
                params.setRegistrantEPR(null);
                EndpointReferenceType epr = new EndpointReferenceType();
                epr.setAddress((AttributedURI)new Address(upstreamEntry));
                String dup = (String)this.downstreamTable.get(upstreamEntry);
                if (dup != null) {
                    logger.warn((Object)("Check configuration - a matching downstream registration was found for a upstream registration for this address: " + upstreamEntry));
                }
                if (AggregatorUtils.detectLoopback((EndpointReferenceType)epr, (EndpointReferenceType)this.localEpr)) {
                    logger.warn((Object)("Check configuration - loopback condition detected in upstream registration - check configuration: Registrant EPR was: [" + epr.getAddress() + "] Local EPR was: [" + this.localEpr.getAddress() + "]"));
                }
                params.setServiceGroupEPR(epr);
                client.register(params, 16000L);
            }
            catch (Exception e) {
                logger.error((Object)("When registering to an upstream index: " + e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleRegConfig readConfig(String filename) throws Exception {
        FileInputStream inputStream = null;
        try {
            SimpleRegConfig config;
            inputStream = new FileInputStream(filename);
            Document doc = XMLUtils.newDocument((InputStream)inputStream);
            SimpleRegConfig simpleRegConfig = config = (SimpleRegConfig)ObjectDeserializer.toObject((Element)doc.getDocumentElement(), (Class)(class$org$globus$mds$index$SimpleRegConfig == null ? (class$org$globus$mds$index$SimpleRegConfig = DefaultIndexService.class$("org.globus.mds.index.SimpleRegConfig")) : class$org$globus$mds$index$SimpleRegConfig));
            return simpleRegConfig;
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

