/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.operators.common.PackageAldreadyDeployedException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Downloader;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.ExternalPackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.Converter;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.Deployable;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackage;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackageFactory;
import org.gcube.common.vremanagement.deployer.impl.state.DeployerResource;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.common.vremanagement.deployer.stubs.deployer.DeployParameters;

public class DeployerOperator
extends GCUBEHandler<DeployerResource> {
    static ReentrantLock deployLock = new ReentrantLock();
    protected final GCUBELog logger = new GCUBELog(DeployerOperator.class);
    private DeployParameters params;
    private boolean rollback = false;
    private DeployerResource resource = null;
    private GCUBEScope callerScope = null;

    public DeployerOperator(DeployParameters params, GCUBEScope callerScope) {
        this.params = params;
        this.callerScope = callerScope;
    }

    public void run() throws Exception {
        PackageInfo[] packages = this.params.get_package();
        String callbackID = this.params.getCallbackID() == null || this.params.getCallbackID().trim() == "" ? "DEFAULT" : this.params.getCallbackID();
        this.logger.trace((Object)("Using callback ID: " + callbackID));
        this.logger.trace((Object)"Locking the Deployer Operator...");
        deployLock.lock();
        this.logger.trace((Object)(deployLock.getClass().getSimpleName() + " - Lock acquired"));
        this.resource = (DeployerResource)((Object)this.getHandled());
        Report finalreport = new Report(this.params.getEndpointReference(), callbackID, packages.length, Report.TYPE.DEPLOY, this.callerScope);
        this.resource.setLastDeployment(callbackID);
        for (int i = 0; i < packages.length; ++i) {
            PackageInfo deployable_package = packages[i];
            finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.WAITING, i, new String[0]);
        }
        HashSet<GCUBEScope> targets = new HashSet<GCUBEScope>();
        for (String scope : this.params.getTargetScope()) {
            targets.add(GCUBEScope.getScope((String)scope));
        }
        this.logger.trace((Object)"Looping on the packages..");
        boolean restart = false;
        for (int i = 0; i < packages.length; ++i) {
            PackageInfo deployable_package = packages[i];
            this.logger.info((Object)("Deploying package " + deployable_package.getName() + "... "));
            if (this.rollback) {
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.SKIPPED, i, "The package could not be deployed because it depends on a package which has an error");
                this.logger.warn((Object)("The package " + deployable_package.getName() + " could not be deployed because it depends on a package which has an error"));
                continue;
            }
            try {
                Downloader downloader = new Downloader(deployable_package, new boolean[0]);
                if (!this.downloadFromHTTPPath(deployable_package, downloader) && !this.downloadFromLocalPath(deployable_package, downloader)) {
                    this.downloadFromRepository(deployable_package, downloader, this.callerScope);
                }
                Deployable pack = null;
                if (downloader.getPackagetype() == Downloader.PackageType.SERVICEARCHIVE) {
                    pack = new PackageExtractor(downloader).getPackage();
                } else if (downloader.getPackagetype() == Downloader.PackageType.JAR) {
                    pack = new ExternalPackageExtractor(downloader).getPackage();
                }
                this.deployPackage(pack, finalreport, deployable_package, targets, i);
                if (!pack.requireRestart()) continue;
                restart = true;
                continue;
            }
            catch (Downloader.UnreachablePackageException ue) {
                this.logger.warn((Object)("The package " + deployable_package.getName() + " has NOT been successfully deployed"), (Throwable)ue);
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.FAILED, i, "The package has NOT been successfully deployed. Possible cause: unable to download the package from the Software Repository");
                this.rollback = true;
                continue;
            }
            catch (Exception e) {
                this.logger.warn((Object)("The package " + deployable_package.getName() + " has NOT been successfully deployed"), (Throwable)e);
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.FAILED, i, "The package has NOT been successfully deployed. Possible cause: " + e.getMessage());
                this.rollback = true;
            }
        }
        if (this.rollback) {
            finalreport = this.rollback(finalreport);
        }
        if (restart) {
            finalreport.send();
            finalreport.save();
            GHNContext.getContext().restart(new String[0]);
        } else {
            finalreport.close();
            finalreport.send();
            finalreport.save();
        }
        deployLock.unlock();
    }

    private boolean downloadFromLocalPath(PackageInfo deployable_package, Downloader manager) {
        if (deployable_package.getLocation() == null) {
            return false;
        }
        try {
            this.logger.trace((Object)("Using local path at " + deployable_package.getLocation().getLocalPath() + "... "));
            manager.downloadPackage(new File(deployable_package.getLocation().getLocalPath()));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private boolean downloadFromHTTPPath(PackageInfo deployable_package, Downloader manager) {
        if (deployable_package.getLocation() == null) {
            return false;
        }
        try {
            this.logger.trace((Object)("Using HTTP location at " + deployable_package.getLocation().getHttpPath() + "... "));
            manager.downloadPatch(new URI(deployable_package.getLocation().getHttpPath()));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployPackage(Deployable pack, Report finalreport, PackageInfo deployable_package, Set<GCUBEScope> targets, int i) throws Exception {
        if (pack != null) {
            try {
                if (!this.resource.isDeployed(pack.getSourcePackage())) {
                    PlatformDescription packagePlatform = pack.getTargetPlatform();
                    if (packagePlatform == null || packagePlatform.getName().equalsIgnoreCase("gCore")) {
                        pack.deploy(targets);
                        if (pack.verify()) {
                            finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.DEPLOYED, i, new String[0]);
                        } else {
                            finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.NOTVERIFIED, i, new String[0]);
                        }
                    } else {
                        this.logger.debug((Object)("The target platform for the package is " + packagePlatform.toString()));
                        String id = pack.deployApp(targets);
                        finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.ACTIVATED, i, new String[0]);
                        finalreport.addRI(id, deployable_package);
                    }
                    this.logger.info((Object)("The package " + deployable_package.getName() + " has been successfully deployed"));
                    this.logger.trace((Object)("Adding package " + pack.getSourcePackage().getKey() + " to the serialized state"));
                    this.resource.addPackage(pack.getSourcePackage());
                }
                this.logger.info((Object)("The package " + deployable_package.getName() + " has been already deployed"));
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.ALREADYDEPLOYED, i, new String[0]);
                pack.getSourcePackage().setScopes(targets);
                this.resource.addPackage(pack.getSourcePackage());
            }
            catch (PackageAldreadyDeployedException ade) {
                this.logger.info((Object)("The package " + deployable_package.getName() + " has been already deployed"));
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.ALREADYDEPLOYED, i, new String[0]);
                pack.getSourcePackage().setScopes(targets);
                this.resource.addPackage(pack.getSourcePackage());
            }
            finally {
                pack.clean();
            }
        } else {
            throw new Exception("unable to find the package description in the service profile");
        }
    }

    private boolean downloadFromRepository(PackageInfo deployable_package, Downloader manager, GCUBEScope scope) throws Downloader.UnreachablePackageException, Exception {
        this.logger.debug((Object)"Trying to download from the Software Gateway... ");
        manager.downloadPackage(scope);
        return true;
    }

    private Report rollback(Report finalreport) {
        this.logger.info((Object)"Rollback operation on deployerOperator ");
        int i = 0;
        ArrayList<PackageInfo> pInfoList = new ArrayList<PackageInfo>();
        try {
            while (true) {
                PackageInfo pInfo = finalreport.getPackageInfo(i);
                this.logger.info((Object)("added package: " + pInfo.getName() + " for undeploying"));
                pInfoList.add(i, pInfo);
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.info((Object)("package list size founded: " + pInfoList.size()));
            PackageInfo[] packages = new PackageInfo[pInfoList.size()];
            this.undeployPackagesList(pInfoList.toArray(packages), finalreport);
            return finalreport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployPackagesList(PackageInfo[] packages, Report finalreport) {
        this.logger.trace((Object)" undeployPackageList method ");
        HashSet<GCUBEScope> scopes = new HashSet<GCUBEScope>();
        scopes.add(this.callerScope);
        boolean restart = false;
        for (int i = 0; i < packages.length; ++i) {
            try {
                String packageStatus = finalreport.getPackageStatus(i);
                BaseTypedPackage base = ((DeployerResource)((Object)this.getHandled())).getPackage(Converter.toBasePackage(packages[i]).getKey());
                this.logger.info((Object)("package status founded: " + packageStatus + " with sc: " + packages[i].getServiceClass() + " and sn: " + packages[i].getServiceName()));
                if (packageStatus.equalsIgnoreCase("DEPLOYED")) {
                    this.logger.info((Object)("Checking package " + base.getKey() + " for undeployment"));
                    UndeployablePackage undeployablePackage = UndeployablePackageFactory.makeUndeployable(base);
                    PlatformDescription packagePlatform = undeployablePackage.getTargetPlatform();
                    if (packagePlatform == null || packagePlatform.getName().equalsIgnoreCase("gCore")) {
                        this.logger.info((Object)("The package " + undeployablePackage.getKey() + " is going to be undeployed"));
                        undeployablePackage.undeploy(scopes, false);
                        if (undeployablePackage.verify()) {
                            finalreport.updatePackageStatus(packages[i], Report.PACKAGESTATUS.UNDEPLOYED, "Undeployed cause package deploying failed");
                            this.logger.info((Object)("The package " + packages[i].getName() + " has been successfully undeployed"));
                        } else {
                            finalreport.updatePackageStatus(packages[i], Report.PACKAGESTATUS.NOTVERIFIED, "Undeployed cause package deploying failed");
                            this.logger.info((Object)("The package " + packages[i].getName() + " has been successfully undeployed, but not verified"));
                        }
                        ((DeployerResource)((Object)this.getHandled())).removePackage(undeployablePackage);
                    } else {
                        try {
                            undeployablePackage.undeploy(scopes, false);
                            finalreport.updatePackageStatus(packages[i], Report.PACKAGESTATUS.UNDEPLOYED, "Undeployed cause package deploying failed");
                            this.logger.info((Object)("The package " + packages[i].getName() + " has been successfully undeployed"));
                        }
                        finally {
                            ((DeployerResource)((Object)this.getHandled())).removePackage(undeployablePackage);
                        }
                    }
                    if (!undeployablePackage.requireRestart()) continue;
                    restart = true;
                    continue;
                }
                if (packageStatus.equalsIgnoreCase("SKIPPED")) continue;
                this.logger.info((Object)("The package " + packages[i].getName() + " cannot be undeployed"));
                base.removeScopes(scopes);
                this.logger.info((Object)("The package has been removed from the target undeployment scope(s) " + scopes));
                finalreport.updatePackageStatus(packages[i], Report.PACKAGESTATUS.REMOVEDFROMSCOPE, "the package has been only removed from the scope, but it cannot be undeployed because of it is shared with other scopes");
                finalreport.addPackage(packages[i], Report.PACKAGESTATUS.REMOVEDFROMSCOPE, i, "the package has been only removed from the scope, but it cannot be undeployed because of it is shared with other scopes");
                continue;
            }
            catch (Exception e) {
                this.logger.info((Object)("Exception catched: " + e.getMessage()));
            }
        }
    }
}

