/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.notification.impl.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.notification.impl.client.NotificationBroker;

public class BrokerPool {
    private static GCUBELog logger = new GCUBELog(BrokerPool.class);
    private static HashMap<String, BrokerPool> brokerPerScope = new HashMap();
    private List<NotificationBroker> brokerlist = Collections.synchronizedList(new ArrayList());
    private GCUBEScope scope;

    public static synchronized BrokerPool getBrokerPool(GCUBEScope gCUBEScope) {
        if (brokerPerScope.get(gCUBEScope.toString()) == null) {
            BrokerPool brokerPool = new BrokerPool(gCUBEScope);
            brokerPerScope.put(gCUBEScope.toString(), brokerPool);
            return brokerPool;
        }
        return brokerPerScope.get(gCUBEScope.toString());
    }

    private BrokerPool(GCUBEScope gCUBEScope) {
        this.scope = gCUBEScope;
    }

    public synchronized void registerTopic(ISNotifier.GCUBENotificationTopic gCUBENotificationTopic, ISNotifier.BaseNotificationConsumer baseNotificationConsumer, GCUBESecurityManager gCUBESecurityManager) {
        logger.debug((Object)("the size of notifications broker list is " + this.brokerlist.size()));
        for (NotificationBroker notificationBroker : this.brokerlist) {
            if (notificationBroker.containsTopic(gCUBENotificationTopic.getTopicQName())) continue;
            logger.debug((Object)("reusing notification broker for topic " + gCUBENotificationTopic.getTopicQName().toString()));
            notificationBroker.subscribeForAnyTopic(baseNotificationConsumer, gCUBENotificationTopic, gCUBESecurityManager, this.scope);
            return;
        }
        logger.debug((Object)("creating a new notification broker for topic " + gCUBENotificationTopic.getTopicQName().toString()));
        Object object = null;
        try {
            object = new NotificationBroker();
            ((NotificationBroker)object).subscribeForAnyTopic(baseNotificationConsumer, gCUBENotificationTopic, gCUBESecurityManager, this.scope);
            this.brokerlist.add((NotificationBroker)object);
        }
        catch (Exception exception) {
            logger.error((Object)"error registering the topic ", (Throwable)exception);
        }
    }

    public synchronized void unregisterTopic(ISNotifier.GCUBENotificationTopic gCUBENotificationTopic, GCUBESecurityManager gCUBESecurityManager) {
        if (this.brokerlist.size() == 0) {
            logger.warn((Object)"no topics are registered in this scope");
            return;
        }
        logger.debug((Object)("the size of notifications broker list is " + this.brokerlist.size()));
        ArrayList<NotificationBroker> arrayList = new ArrayList<NotificationBroker>();
        boolean bl = false;
        for (NotificationBroker notificationBroker : this.brokerlist) {
            if (!notificationBroker.containsTopic(gCUBENotificationTopic)) continue;
            notificationBroker.unsubscribeFromAnyTopic(gCUBENotificationTopic, gCUBESecurityManager, this.scope);
            if (notificationBroker.relatedTopic.size() == 0) {
                notificationBroker.stopListening();
                arrayList.add(notificationBroker);
            }
            bl = true;
            break;
        }
        logger.trace((Object)("removing " + arrayList.size() + " to notification pool in scope " + this.scope));
        for (NotificationBroker notificationBroker : arrayList) {
            this.brokerlist.remove(notificationBroker);
        }
        if (!bl) {
            logger.warn((Object)("the specific topic with QNAME " + gCUBENotificationTopic.getTopicQName() + " is not registered"));
        }
    }
}

