/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import ise.library.UserPreferencesFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class UserPreferences
extends AbstractPreferences {
    private Hashtable root = new Hashtable();
    private Hashtable children = new Hashtable();
    private boolean isRemoved = false;

    public UserPreferences(UserPreferences prefs, String name) {
        super(prefs, name);
        try {
            this.sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void putSpi(String key, String value) {
        this.root.put(key, value);
    }

    protected String getSpi(String key) {
        return (String)this.root.get(key);
    }

    protected void removeSpi(String key) {
        this.root.remove(key);
    }

    protected void removeNodeSpi() throws BackingStoreException {
        this.isRemoved = true;
    }

    protected String[] keysSpi() throws BackingStoreException {
        return this.root.keySet().toArray(new String[0]);
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.children.keySet().toArray(new String[0]);
    }

    protected AbstractPreferences childSpi(String name) {
        UserPreferences child = (UserPreferences)this.children.get(name);
        if (child == null || child.isRemoved()) {
            try {
                child = new UserPreferences(this, name);
                this.children.put(name, child);
            }
            catch (Exception e) {
                e.printStackTrace();
                child = null;
            }
        }
        return child;
    }

    protected File getDirectory() {
        try {
            String name = this.name();
            if (name == null || name.equals("")) {
                name = "root";
            }
            File dir = this.parent() == null ? UserPreferencesFactory.PREFS_ROOT : ((UserPreferences)this.parent()).getDirectory();
            File my_dir = new File(dir, name);
            my_dir.mkdirs();
            return my_dir;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void syncSpi() throws BackingStoreException {
    }

    public void sync() throws BackingStoreException {
        try {
            File f;
            if (this.isRemoved()) {
                this.parent().sync();
                return;
            }
            if (this.root == null) {
                this.root = new Hashtable();
            }
            if (!(f = new File(this.getDirectory(), "prefs")).exists()) {
                return;
            }
            ObjectInputStream decoder = new ObjectInputStream(new FileInputStream(f));
            Hashtable map = (Hashtable)decoder.readObject();
            decoder.close();
            this.root.putAll(map);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flushSpi() throws BackingStoreException {
        try {
            if (this.root == null || this.root.size() == 0) {
                return;
            }
            if (this.isRemoved()) {
                this.parent().flush();
                return;
            }
            File dir = this.getDirectory();
            if (dir == null) {
                throw new BackingStoreException("Can't open directory.");
            }
            File f = new File(dir, "prefs");
            ObjectOutputStream encoder = new ObjectOutputStream(new FileOutputStream(f));
            encoder.writeObject(this.root);
            encoder.close();
        }
        catch (BackingStoreException bse) {
            throw bse;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isRemoved() {
        return this.isRemoved;
    }
}

