/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.TypeHandler;
import org.apache.commons.cli.Util;

public class CommandLine {
    private List args = new LinkedList();
    private Map options = new HashMap();
    private Map names = new HashMap();
    private Map hashcodeMap = new HashMap();
    private Option[] optionsArray;

    CommandLine() {
    }

    public boolean hasOption(String opt) {
        return this.options.containsKey(opt);
    }

    public boolean hasOption(char opt) {
        return this.hasOption(String.valueOf(opt));
    }

    public Object getOptionObject(String opt) {
        String res = this.getOptionValue(opt);
        if (!this.options.containsKey(opt)) {
            return null;
        }
        Object type = ((Option)this.options.get(opt)).getType();
        return res == null ? null : TypeHandler.createValue(res, type);
    }

    public Object getOptionObject(char opt) {
        return this.getOptionObject(String.valueOf(opt));
    }

    public String getOptionValue(String opt) {
        String[] values = this.getOptionValues(opt);
        return values == null ? null : values[0];
    }

    public String getOptionValue(char opt) {
        return this.getOptionValue(String.valueOf(opt));
    }

    public String[] getOptionValues(String opt) {
        String key = opt = Util.stripLeadingHyphens(opt);
        if (this.names.containsKey(opt)) {
            key = (String)this.names.get(opt);
        }
        if (this.options.containsKey(key)) {
            return ((Option)this.options.get(key)).getValues();
        }
        return null;
    }

    public String[] getOptionValues(char opt) {
        return this.getOptionValues(String.valueOf(opt));
    }

    public String getOptionValue(String opt, String defaultValue) {
        String answer = this.getOptionValue(opt);
        return answer != null ? answer : defaultValue;
    }

    public String getOptionValue(char opt, String defaultValue) {
        return this.getOptionValue(String.valueOf(opt), defaultValue);
    }

    public String[] getArgs() {
        String[] answer = new String[this.args.size()];
        this.args.toArray(answer);
        return answer;
    }

    public List getArgList() {
        return this.args;
    }

    void addArg(String arg) {
        this.args.add(arg);
    }

    void addOption(Option opt) {
        this.hashcodeMap.put(new Integer(opt.hashCode()), opt);
        String key = opt.getKey();
        if (key == null) {
            key = opt.getLongOpt();
        } else {
            this.names.put(opt.getLongOpt(), key);
        }
        this.options.put(key, opt);
    }

    public Iterator iterator() {
        return this.hashcodeMap.values().iterator();
    }

    public Option[] getOptions() {
        Collection processed = this.options.values();
        this.optionsArray = new Option[processed.size()];
        return processed.toArray(this.optionsArray);
    }
}

