/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration.utils;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Utils {
    public static final String SECURITY_TOKEN = "SECURITY_TOKEN";
    public static final String BINARY_SECURITY_TOKEN_LABEL = "BinarySecurityToken";
    public static final String BINARY_SECURITY_TOKEN_PREFIX = "wsse";
    public static final String WSSE_NAMESPACE = "http://schemas.xmlsoap.org/ws/2002/04/secext";
    public static final String VALUE_TYPE_LABEL = "ValueType";
    public static final String ENCODING_TYPE_LABEL = "EncodingType";
    public static final String BASE64 = "wsse:Base64Binary";
    public static final String ID_LABEL = "Id";
    public static final String SECURITY_TOKEN_ATTR = "SecurityToken";
    public static final String SOA3_ACCESS_SERVICE = "access";

    public static Element generateBinaryTokenElement(String type, String binaryTokenValue) throws Exception {
        Logger log = LoggerFactory.getLogger(Utils.class);
        log.debug("Generating token SOAP element");
        log.debug("Type = " + type);
        log.debug("Value = " + binaryTokenValue);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document tokenDocument = builder.newDocument();
        Element tokenElement = tokenDocument.createElementNS(WSSE_NAMESPACE, "wsse:BinarySecurityToken");
        tokenElement.setAttribute(VALUE_TYPE_LABEL, type);
        tokenElement.setAttribute(ENCODING_TYPE_LABEL, BASE64);
        tokenElement.setAttribute(ID_LABEL, SECURITY_TOKEN);
        tokenElement.setTextContent(binaryTokenValue);
        log.debug("Header completed");
        return tokenElement;
    }
}

