/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.common.security.impl;

import it.eng.rdlab.soa3.connector.utils.SecurityManager;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.gcube.soa3.connector.common.security.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509TLSCredentials
implements Credentials {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final String X509TLS = "X509TLS";
    private String certFile;
    private String keyFile;
    private String trustDir;
    private static boolean providerAdded = false;
    private boolean isReady;

    public X509TLSCredentials() {
        this(null, null, null, null, null);
    }

    public X509TLSCredentials(String certFile, String keyFile, char[] keyPassword, String trustDir, String trustExt) {
        if (certFile != null) {
            SecurityManager.getInstance().setCertFile(certFile);
            this.certFile = certFile;
        } else {
            this.certFile = "/etc/grid-security/hostcert.pem";
        }
        if (keyFile != null) {
            SecurityManager.getInstance().setKeyFile(keyFile);
            this.keyFile = keyFile;
        } else {
            this.keyFile = "/etc/grid-security/hostkey.pem";
        }
        if (trustDir != null) {
            SecurityManager.getInstance().setTrustDir(trustDir);
            this.trustDir = trustDir;
        } else {
            this.trustDir = "/etc/grid-security/certificates/";
        }
        if (trustExt != null) {
            SecurityManager.getInstance().setTrustExt(trustExt);
        }
        if (keyPassword != null) {
            SecurityManager.getInstance().setPrivateKeyPassword(keyPassword);
        }
        this.isReady = false;
    }

    @Override
    public void prepareCredentials() {
        if (!this.isReady) {
            this.log.debug("Loading certificates");
            try {
                if (!providerAdded) {
                    this.log.debug("Adding bouncycastle provider...");
                    Security.addProvider((Provider)new BouncyCastleProvider());
                    providerAdded = true;
                    this.log.debug("Provider added");
                }
                SecurityManager.getInstance().loadCertificate();
                this.log.debug("Certificates loaded");
                this.isReady = true;
            }
            catch (Exception e) {
                this.log.error("Unable to load security certificates", (Throwable)e);
            }
        }
    }

    @Override
    public String getAuthenticationType() {
        return "X509TLS";
    }

    @Override
    public String getAuthenticationString() {
        return "Certificate " + this.certFile + " Key " + this.keyFile + " Trust Dir " + this.trustDir;
    }

    @Override
    public String getHeaderString() {
        return null;
    }

    public static void main(String[] args) {
        X509TLSCredentials cred = new X509TLSCredentials();
        cred.prepareCredentials();
    }

    @Override
    public void disposeCredentials() {
        SecurityManager.getInstance().removeCertificate();
        this.isReady = false;
    }

    @Override
    public boolean isPrepared() {
        return this.isReady;
    }
}

