/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tomcat.catalina.net;

import java.io.IOException;
import java.net.Socket;
import org.globus.common.ChainedIOException;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.security.gridmap.GridMap;
import org.globus.tomcat.catalina.net.HTTPSSocket;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class GSISocket
extends HTTPSSocket {
    protected GridMap gridMap;
    protected GSSCredential delegatedCreds;
    protected String userID;
    private boolean init = false;

    public GSISocket(Socket socket, GSSContext context) {
        super(socket, context);
    }

    public void setGridMap(GridMap gridMap) {
        this.gridMap = gridMap;
    }

    public GSSCredential getDelegatedCredentials() {
        return this.delegatedCreds;
    }

    public String getAuthorizedUserName() {
        return this.userID;
    }

    public String getAuthorizedUserDN() {
        return this.getUserDN();
    }

    public synchronized void startHandshake() throws IOException {
        super.startHandshake();
        if (this.init) {
            return;
        }
        GSSContext context = this.getContext();
        try {
            this.delegatedCreds = context.getDelegCred();
        }
        catch (GSSException e) {
            throw new ChainedIOException("Failed to retreive context properties", (Throwable)e);
        }
        this.userID = this.gridMap.getUserID(this.userDN);
        if (this.userID == null) {
            throw new AuthorizationException("User not authenticated: " + this.userDN);
        }
        this.init = true;
    }
}

