/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tomcat.catalina.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.globus.common.ChainedIOException;
import org.globus.gsi.gssapi.net.GssOutputStream;
import org.globus.gsi.gssapi.net.impl.GSIGssInputStream;
import org.globus.gsi.gssapi.net.impl.GSIGssSocket;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public class HTTPSSocket
extends GSIGssSocket {
    protected boolean autoFlush;
    protected String userDN;
    private boolean init = false;

    public HTTPSSocket(Socket socket, GSSContext context) {
        super(socket, context);
        this.setAuthorization(null);
    }

    void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public String getUserDN() {
        return this.userDN;
    }

    public synchronized void startHandshake() throws IOException {
        super.startHandshake();
        if (this.init) {
            return;
        }
        GSSContext context = this.getContext();
        try {
            this.userDN = ((Object)context.getSrcName()).toString();
        }
        catch (GSSException e) {
            throw new ChainedIOException("Failed to retreive context properties", (Throwable)e);
        }
        if (this.out != null) {
            ((GssOutputStream)this.out).setAutoFlush(this.autoFlush);
        }
        this.init = true;
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        super.close();
    }

    public void shutdownOutput() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
        super.shutdownOutput();
    }

    protected byte[] readToken() throws IOException {
        if (this.in == null) {
            this.in = new SocketGSIGssInputStream(this.socket.getInputStream(), this.context, this);
        }
        return super.readToken();
    }

    public static class SocketGSIGssInputStream
    extends GSIGssInputStream {
        private HTTPSSocket socket;

        public SocketGSIGssInputStream(InputStream in, GSSContext context, HTTPSSocket socket) {
            super(in, context);
            this.socket = socket;
        }

        public HTTPSSocket getSocket() {
            return this.socket;
        }
    }
}

