/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.logparser;

import java.text.ParseException;
import java.util.Date;
import java.util.StringTokenizer;
import org.gcube.common.accounting.node.logparser.RIInvocationParser;
import org.gcube.common.accounting.node.util.Util;
import org.gcube.common.core.scope.GCUBEScope;

public class LogEntry {
    RIInvocationParser.EntryType type = null;
    String line;
    CallInfo info;
    GCUBEScope scope;
    double invocationTime;
    Date startDate;
    String time;
    private static final String tokensSeparator = ",";

    public LogEntry(RIInvocationParser.EntryType type, String line, String time) throws ParseException {
        this.type = type;
        this.line = line;
        this.startDate = this.createStartDate(time);
        this.time = time;
        this.parse(line);
    }

    private void parse(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, tokensSeparator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.startsWith(RIInvocationParser.EntryType.ENDCALL.type)) {
                this.info = new CallInfo(token.substring(token.indexOf("(") + 1, token.indexOf(")")), token.substring(token.lastIndexOf("(") + 1, token.lastIndexOf(")")));
                continue;
            }
            if (token.startsWith("/")) {
                this.scope = GCUBEScope.getScope((String)token);
                continue;
            }
            if (!token.startsWith("[")) continue;
            this.invocationTime = Double.valueOf(token.substring(token.indexOf("[") + 1, token.indexOf("]")));
        }
    }

    private Date createStartDate(String time) throws ParseException {
        return Util.format.parse(time);
    }

    public CallInfo getInfo() {
        return this.info;
    }

    public void setInfo(CallInfo info) {
        this.info = info;
    }

    public double getInvocationTime() {
        return this.invocationTime;
    }

    public void setInvocationTime(double invocationTime) {
        this.invocationTime = invocationTime;
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    public void setScope(GCUBEScope scope) {
        this.scope = scope;
    }

    public RIInvocationParser.EntryType getType() {
        return this.type;
    }

    public void setType(RIInvocationParser.EntryType type) {
        this.type = type;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public class CallInfo {
        private String serviceName;
        private String serviceClass;
        private String callerIP;

        public CallInfo(String from, String to) {
            this.serviceClass = to.substring(0, to.indexOf(":"));
            String temp = to.substring(to.indexOf(":") + 1);
            this.serviceName = temp = temp.substring(0, temp.indexOf(":"));
            this.callerIP = from;
        }

        public String toString() {
            return this.serviceClass + "_" + this.serviceName;
        }

        public String getServiceClass() {
            return this.serviceClass;
        }

        public void setServiceClass(String serviceClass) {
            this.serviceClass = serviceClass;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getCallerIP() {
            return this.callerIP;
        }

        public void setCallerIP(String callerIP) {
            this.callerIP = callerIP;
        }
    }
}

