/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.accounting.node.probes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.gcube.common.accounting.node.persistence.PersistenceAdapter;
import org.gcube.common.accounting.node.probes.RIProfileUpdater;
import org.gcube.common.accounting.node.util.DateInterval;
import org.gcube.common.accounting.node.util.Util;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.monitoring.GCUBETestProbe;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.messages.NodeAccountingMessage;
import org.gcube.messaging.common.messages.records.IntervalRecord;
import org.gcube.messaging.common.producer.ActiveMQClient;
import org.gcube.messaging.common.producer.GCUBELocalProducer;

public class NodeAccountingProbe
extends GCUBETestProbe {
    private String logsLocation = System.getenv("GLOBUS_LOCATION") + File.separator + "logs";
    private PersistenceAdapter persistenceAdapter = null;
    private Util util = null;
    private Long interval = null;
    private boolean updateIS = true;
    private Properties properties = new Properties();

    private File[] getLogFileToParse() {
        File logsLocationFolder = new File(this.logsLocation);
        return logsLocationFolder.listFiles(new AccessLogFilter());
    }

    public void run() throws Exception {
        try {
            this.properties.load(new FileInputStream(System.getenv("GLOBUS_LOCATION") + File.separator + "config" + File.separator + "NodeAccounting.properties"));
            this.setInterval(Long.valueOf((String)this.properties.get("PROBING_INTERVAL")));
            this.updateIS = Boolean.valueOf((String)this.properties.get("PUBLISH_ON_IS"));
            if (GHNContext.getContext().getStatus().compareTo((Enum)GHNContext.Status.CERTIFIED) != 0) {
                this.setInterval(40L);
                this.logger.debug((Object)"GHN not YET Ready, retrying in 40 seconds");
                return;
            }
            this.util = new Util(this.logger);
            this.interval = this.getInterval() / 1000L;
            this.persistenceAdapter = new PersistenceAdapter(this.logger, this.interval);
            this.persistenceAdapter.load();
            if (this.persistenceAdapter.alreadyUpdated()) {
                this.logger.debug((Object)"Node Accounting info already updated, skip to next execution");
                return;
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error on initialization", (Throwable)e);
            throw e;
        }
        HashMap<DateInterval, ArrayList<NodeAccountingMessage<IntervalRecord>>> messages = new HashMap<DateInterval, ArrayList<NodeAccountingMessage<IntervalRecord>>>();
        ArrayList<DateInterval> intervals = this.util.generateDateIntervals(this.persistenceAdapter, this.interval);
        HashMap<File, ArrayList<DateInterval>> map = this.util.matchIntervalsWithLogFiles(this.getLogFileToParse(), intervals);
        if (map.size() == 0) {
            this.logger.warn((Object)"No log File to parse");
            return;
        }
        for (File file : map.keySet()) {
            for (DateInterval interval : map.get(file)) {
                try {
                    this.logger.debug((Object)("Trying to aggregate logs from " + interval.getStartDateAsString() + " to " + interval.getEndDateAsString() + " from File " + file));
                    messages.put(interval, this.util.createAccountingInfo(file, interval));
                    if (messages.get(interval) != null) {
                        if (((ArrayList)messages.get(interval)).size() != 0) {
                            for (GCUBEScope scope : GCUBELocalProducer.getMonitoredScope()) {
                                for (NodeAccountingMessage message : (ArrayList)messages.get(interval)) {
                                    message.setScope(scope.toString());
                                    message.setSourceGHN(GHNContext.getContext().getHostnameAndPort());
                                    message.createTopicName(scope.toString());
                                    this.sendMessage((org.gcube.messaging.common.messages.GCUBEMessage)message);
                                }
                            }
                            continue;
                        }
                        this.logger.debug((Object)"No messages to send");
                        continue;
                    }
                    this.logger.debug((Object)"No messages to send");
                }
                catch (IOException e) {
                    this.logger.error((Object)("Error Reading log file:" + file), (Throwable)e);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Error Executing Node Accounting probe on logFile:" + file), (Throwable)e);
                }
            }
        }
        for (DateInterval interval : intervals) {
            ArrayList message = (ArrayList)messages.get(interval);
            try {
                this.util.updateAccoutingInfo(message, this.persistenceAdapter, interval);
            }
            catch (Exception e) {
                this.logger.error((Object)"Error Updating Accounting info", (Throwable)e);
            }
        }
        if (this.updateIS) {
            for (String ri : this.persistenceAdapter.getMap().keySet()) {
                try {
                    RIProfileUpdater updater = new RIProfileUpdater(this.persistenceAdapter.getMap().get(ri));
                    updater.run();
                }
                catch (Exception e) {
                    this.logger.error((Object)"Error Updating RIProfile", (Throwable)e);
                }
            }
        }
    }

    public void sendMessage(org.gcube.messaging.common.messages.GCUBEMessage message) {
        ActiveMQClient.getSingleton().sendMessageToQueue(message);
    }

    public void sendMessage(GCUBEMessage arg0) {
    }

    private class AccessLogFilter
    implements FilenameFilter {
        private AccessLogFilter() {
        }

        @Override
        public boolean accept(File file, String name) {
            return name.startsWith("access.log");
        }
    }
}

