/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;
import java.util.Random;

public class FJTaskRunner
extends Thread {
    protected final FJTaskRunnerGroup group;
    protected static final int INITIAL_CAPACITY = 4096;
    protected static final int MAX_CAPACITY = 0x40000000;
    protected VolatileTaskRef[] deq = VolatileTaskRef.newArray(4096);
    protected volatile int top = 0;
    protected volatile int base = 0;
    protected final Object barrier = new Object();
    protected boolean active = false;
    protected final Random victimRNG;
    protected int scanPriority = 2;
    protected int runPriority;
    static final boolean COLLECT_STATS = true;
    protected int runs = 0;
    protected int scans = 0;
    protected int steals = 0;

    protected FJTaskRunner(FJTaskRunnerGroup fJTaskRunnerGroup) {
        this.group = fJTaskRunnerGroup;
        this.victimRNG = new Random(System.identityHashCode(this));
        this.runPriority = this.getPriority();
        this.setDaemon(true);
    }

    protected final FJTaskRunnerGroup getGroup() {
        return this.group;
    }

    protected int deqSize() {
        return this.deq.length;
    }

    protected void setScanPriority(int n) {
        this.scanPriority = n;
    }

    protected void setRunPriority(int n) {
        this.runPriority = n;
    }

    protected final void push(FJTask fJTask) {
        int n = this.top;
        if (n < (this.base & this.deq.length - 1) + this.deq.length) {
            this.deq[n & this.deq.length - 1].put(fJTask);
            this.top = n + 1;
        } else {
            this.slowPush(fJTask);
        }
    }

    protected synchronized void slowPush(FJTask fJTask) {
        this.checkOverflow();
        this.push(fJTask);
    }

    protected final synchronized void put(FJTask fJTask) {
        while (true) {
            int n;
            if (this.top < (n = this.base - 1) + this.deq.length) {
                int n2 = n & this.deq.length - 1;
                this.deq[n2].put(fJTask);
                this.base = n2;
                if (n != n2) {
                    int n3 = this.top & this.deq.length - 1;
                    if (n3 < n2) {
                        n3 += this.deq.length;
                    }
                    this.top = n3;
                }
                return;
            }
            this.checkOverflow();
        }
    }

    protected final FJTask pop() {
        int n;
        if (this.base + 1 < (n = --this.top)) {
            return this.deq[n & this.deq.length - 1].take();
        }
        return this.confirmPop(n);
    }

    protected final synchronized FJTask confirmPop(int n) {
        if (this.base <= n) {
            return this.deq[n & this.deq.length - 1].take();
        }
        this.base = 0;
        this.top = 0;
        return null;
    }

    protected final synchronized FJTask take() {
        int n;
        if ((n = this.base++) < this.top) {
            return this.confirmTake(n);
        }
        this.base = n;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FJTask confirmTake(int n) {
        Object object = this.barrier;
        synchronized (object) {
            if (n < this.top) {
                return this.deq[n & this.deq.length - 1].get();
            }
            this.base = n;
            return null;
        }
    }

    protected void checkOverflow() {
        int n = this.top;
        int n2 = this.base;
        if (n - n2 < this.deq.length - 1) {
            int n3 = this.top & this.deq.length - 1;
            int n4 = n2 & this.deq.length - 1;
            if (n3 < n4) {
                n3 += this.deq.length;
            }
            this.top = n3;
            this.base = n4;
            int n5 = n4;
            while (n5 != n3 && this.deq[n5].ref != null) {
                this.deq[n5].ref = null;
                n5 = n5 - 1 & this.deq.length - 1;
            }
        } else {
            int n6 = n - n2;
            int n7 = this.deq.length;
            int n8 = n7 * 2;
            if (n8 >= 0x40000000) {
                throw new Error("FJTask queue maximum capacity exceeded");
            }
            VolatileTaskRef[] volatileTaskRefArray = new VolatileTaskRef[n8];
            int n9 = 0;
            while (n9 < n7) {
                volatileTaskRefArray[n9] = this.deq[n2++ & n7 - 1];
                ++n9;
            }
            int n10 = n7;
            while (n10 < n8) {
                volatileTaskRefArray[n10] = new VolatileTaskRef();
                ++n10;
            }
            this.deq = volatileTaskRefArray;
            this.base = 0;
            this.top = n6;
        }
    }

    protected void scan(FJTask fJTask) {
        FJTask fJTask2 = null;
        boolean bl = false;
        FJTaskRunner[] fJTaskRunnerArray = this.group.getArray();
        int n = this.victimRNG.nextInt(fJTaskRunnerArray.length);
        int n2 = 0;
        while (n2 < fJTaskRunnerArray.length) {
            FJTaskRunner fJTaskRunner = fJTaskRunnerArray[n];
            if (++n >= fJTaskRunnerArray.length) {
                n = 0;
            }
            if (fJTaskRunner != null && fJTaskRunner != this) {
                if (fJTask != null && fJTask.isDone()) break;
                ++this.scans;
                fJTask2 = fJTaskRunner.take();
                if (fJTask2 != null) {
                    ++this.steals;
                    break;
                }
                if (this.isInterrupted()) break;
                if (!bl) {
                    bl = true;
                    this.setPriority(this.scanPriority);
                } else {
                    Thread.yield();
                }
            }
            ++n2;
        }
        if (fJTask2 == null) {
            ++this.scans;
            fJTask2 = this.group.pollEntryQueue();
            if (fJTask2 != null) {
                ++this.steals;
            }
        }
        if (bl) {
            this.setPriority(this.runPriority);
        }
        if (fJTask2 != null && !fJTask2.isDone()) {
            ++this.runs;
            fJTask2.run();
            fJTask2.setDone();
        }
    }

    protected void scanWhileIdling() {
        FJTask fJTask = null;
        boolean bl = false;
        long l = 0L;
        FJTaskRunner[] fJTaskRunnerArray = this.group.getArray();
        int n = this.victimRNG.nextInt(fJTaskRunnerArray.length);
        do {
            int n2 = 0;
            while (n2 < fJTaskRunnerArray.length) {
                FJTaskRunner fJTaskRunner = fJTaskRunnerArray[n];
                if (++n >= fJTaskRunnerArray.length) {
                    n = 0;
                }
                if (fJTaskRunner != null && fJTaskRunner != this) {
                    ++this.scans;
                    fJTask = fJTaskRunner.take();
                    if (fJTask != null) {
                        ++this.steals;
                        if (bl) {
                            this.setPriority(this.runPriority);
                        }
                        this.group.setActive(this);
                        break;
                    }
                }
                ++n2;
            }
            if (fJTask != null) continue;
            if (this.isInterrupted()) {
                return;
            }
            ++this.scans;
            fJTask = this.group.pollEntryQueue();
            if (fJTask != null) {
                ++this.steals;
                if (bl) {
                    this.setPriority(this.runPriority);
                }
                this.group.setActive(this);
                continue;
            }
            if (++l >= 15L) {
                this.group.checkActive(this, l);
                if (!this.isInterrupted()) continue;
                return;
            }
            if (!bl) {
                bl = true;
                this.setPriority(this.scanPriority);
                continue;
            }
            Thread.yield();
        } while (fJTask == null);
        if (!fJTask.isDone()) {
            ++this.runs;
            fJTask.run();
            fJTask.setDone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (!Thread.interrupted()) {
                FJTask fJTask = this.pop();
                if (fJTask != null) {
                    if (fJTask.isDone()) continue;
                    ++this.runs;
                    fJTask.run();
                    fJTask.setDone();
                    continue;
                }
                this.scanWhileIdling();
            }
            Object var3_2 = null;
            this.group.setInactive(this);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.group.setInactive(this);
            throw throwable;
        }
    }

    protected final void taskYield() {
        FJTask fJTask = this.pop();
        if (fJTask != null) {
            if (!fJTask.isDone()) {
                ++this.runs;
                fJTask.run();
                fJTask.setDone();
            }
        } else {
            this.scan(null);
        }
    }

    protected final void taskJoin(FJTask fJTask) {
        while (!fJTask.isDone()) {
            FJTask fJTask2 = this.pop();
            if (fJTask2 != null) {
                if (fJTask2.isDone()) continue;
                ++this.runs;
                fJTask2.run();
                fJTask2.setDone();
                if (fJTask2 != fJTask) continue;
                return;
            }
            this.scan(fJTask);
        }
    }

    protected final void coInvoke(FJTask fJTask, FJTask fJTask2) {
        int n = this.top;
        if (n < (this.base & this.deq.length - 1) + this.deq.length) {
            this.deq[n & this.deq.length - 1].put(fJTask);
            this.top = n + 1;
            if (!fJTask2.isDone()) {
                ++this.runs;
                fJTask2.run();
                fJTask2.setDone();
            }
            while (!fJTask.isDone()) {
                FJTask fJTask3 = this.pop();
                if (fJTask3 != null) {
                    if (fJTask3.isDone()) continue;
                    ++this.runs;
                    fJTask3.run();
                    fJTask3.setDone();
                    if (fJTask3 != fJTask) continue;
                    return;
                }
                this.scan(fJTask);
            }
        } else {
            this.slowCoInvoke(fJTask, fJTask2);
        }
    }

    protected void slowCoInvoke(FJTask fJTask, FJTask fJTask2) {
        this.push(fJTask);
        FJTask.invoke(fJTask2);
        this.taskJoin(fJTask);
    }

    protected final void coInvoke(FJTask[] fJTaskArray) {
        int n = fJTaskArray.length - 1;
        int n2 = this.top;
        if (n >= 0 && n2 + n < (this.base & this.deq.length - 1) + this.deq.length) {
            int n3 = 0;
            while (n3 < n) {
                this.deq[n2++ & this.deq.length - 1].put(fJTaskArray[n3]);
                this.top = n2;
                ++n3;
            }
            FJTask fJTask = fJTaskArray[n];
            if (!fJTask.isDone()) {
                ++this.runs;
                fJTask.run();
                fJTask.setDone();
            }
            int n4 = 0;
            while (n4 < n) {
                FJTask fJTask2 = fJTaskArray[n4];
                while (!fJTask2.isDone()) {
                    FJTask fJTask3 = this.pop();
                    if (fJTask3 != null) {
                        if (fJTask3.isDone()) continue;
                        ++this.runs;
                        fJTask3.run();
                        fJTask3.setDone();
                        continue;
                    }
                    this.scan(fJTask2);
                }
                ++n4;
            }
        } else {
            this.slowCoInvoke(fJTaskArray);
        }
    }

    protected void slowCoInvoke(FJTask[] fJTaskArray) {
        int n = 0;
        while (n < fJTaskArray.length) {
            this.push(fJTaskArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < fJTaskArray.length) {
            this.taskJoin(fJTaskArray[n2]);
            ++n2;
        }
    }

    protected static final class VolatileTaskRef {
        protected volatile FJTask ref;

        protected VolatileTaskRef() {
        }

        protected final void put(FJTask fJTask) {
            this.ref = fJTask;
        }

        protected final FJTask get() {
            return this.ref;
        }

        protected final FJTask take() {
            FJTask fJTask = this.ref;
            this.ref = null;
            return fJTask;
        }

        protected static VolatileTaskRef[] newArray(int n) {
            VolatileTaskRef[] volatileTaskRefArray = new VolatileTaskRef[n];
            int n2 = 0;
            while (n2 < n) {
                volatileTaskRefArray[n2] = new VolatileTaskRef();
                ++n2;
            }
            return volatileTaskRefArray;
        }
    }
}

