/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SyncCollection;
import EDU.oswego.cs.dl.util.concurrent.SyncSet;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class SyncMap
implements Map {
    protected final Map c_;
    protected final Sync rd_;
    protected final Sync wr_;
    protected final SynchronizedLong syncFailures_ = new SynchronizedLong(0L);
    private transient Set keySet_ = null;
    private transient Set entrySet_ = null;
    private transient Collection values_ = null;

    public SyncMap(Map map, Sync sync) {
        this(map, sync, sync);
    }

    public SyncMap(Map map, ReadWriteLock readWriteLock) {
        this(map, readWriteLock.readLock(), readWriteLock.writeLock());
    }

    public SyncMap(Map map, Sync sync, Sync sync2) {
        this.c_ = map;
        this.rd_ = sync;
        this.wr_ = sync2;
    }

    public Sync readerSync() {
        return this.rd_;
    }

    public Sync writerSync() {
        return this.wr_;
    }

    public long syncFailures() {
        return this.syncFailures_.get();
    }

    protected boolean beforeRead() {
        try {
            this.rd_.acquire();
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.syncFailures_.increment();
            return true;
        }
    }

    protected void afterRead(boolean bl) {
        if (bl) {
            Thread.currentThread().interrupt();
        } else {
            this.rd_.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        boolean bl = this.beforeRead();
        try {
            int n = this.c_.hashCode();
            Object var4_3 = null;
            this.afterRead(bl);
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        boolean bl = this.beforeRead();
        try {
            boolean bl2 = this.c_.equals(object);
            Object var5_4 = null;
            this.afterRead(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        boolean bl = this.beforeRead();
        try {
            int n = this.c_.size();
            Object var4_3 = null;
            this.afterRead(bl);
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean bl = this.beforeRead();
        try {
            boolean bl2 = this.c_.isEmpty();
            Object var4_3 = null;
            this.afterRead(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        boolean bl = this.beforeRead();
        try {
            boolean bl2 = this.c_.containsKey(object);
            Object var5_4 = null;
            this.afterRead(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        boolean bl = this.beforeRead();
        try {
            boolean bl2 = this.c_.containsValue(object);
            Object var5_4 = null;
            this.afterRead(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        boolean bl = this.beforeRead();
        try {
            Object v = this.c_.get(object);
            Object var5_4 = null;
            this.afterRead(bl);
            return v;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        this.wr_.acquire();
        try {
            Object object3 = this.c_.put(object, object2);
            {
                Object var5_5 = null;
                this.wr_.release();
            }
            return object3;
        }
        catch (Throwable throwable) {
            try {
                Object var5_6 = null;
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        this.wr_.acquire();
        try {
            Object v = this.c_.remove(object);
            {
                Object var4_4 = null;
                this.wr_.release();
            }
            return v;
        }
        catch (Throwable throwable) {
            try {
                Object var4_5 = null;
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        try {
            this.wr_.acquire();
            try {
                this.c_.putAll(map);
                Object var3_2 = null;
                this.wr_.release();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.wr_.release();
                throw throwable;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.wr_.acquire();
            try {
                this.c_.clear();
                Object var2_1 = null;
                this.wr_.release();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.wr_.release();
                throw throwable;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        boolean bl = this.beforeRead();
        try {
            if (this.keySet_ == null) {
                this.keySet_ = new SyncSet(this.c_.keySet(), this.rd_, this.wr_);
            }
            Set set = this.keySet_;
            Object var4_3 = null;
            this.afterRead(bl);
            return set;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        boolean bl = this.beforeRead();
        try {
            if (this.entrySet_ == null) {
                this.entrySet_ = new SyncSet(this.c_.entrySet(), this.rd_, this.wr_);
            }
            Set set = this.entrySet_;
            Object var4_3 = null;
            this.afterRead(bl);
            return set;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        boolean bl = this.beforeRead();
        try {
            if (this.values_ == null) {
                this.values_ = new SyncCollection(this.c_.values(), this.rd_, this.wr_);
            }
            Collection collection = this.values_;
            Object var4_3 = null;
            this.afterRead(bl);
            return collection;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }
}

