/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedRef;
import EDU.oswego.cs.dl.util.concurrent.WaitableInt;
import EDU.oswego.cs.dl.util.concurrent.misc.Fraction;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;
import EDU.oswego.cs.dl.util.concurrent.misc.Threads;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class SynchronizationTimer {
    static final int[] nthreadsChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    static final int BLOCK_MODE = 0;
    static final int TIMEOUT_MODE = 1;
    static final int[] syncModes = new int[]{0, 1};
    static final int PRECISION = 10;
    final ThreadInfo[] threadInfo = new ThreadInfo[nthreadsChoices.length];
    static final int headerRows = 1;
    static final int classColumn = 0;
    static final int headerColumns = 1;
    final int tableRows = TestedClass.classes.length + 1;
    final int tableColumns = nthreadsChoices.length + 1;
    final JComponent[][] resultTable_ = new JComponent[this.tableRows][this.tableColumns];
    final SynchronizedInt nextClassIdx_ = new SynchronizedInt(0);
    final SynchronizedInt nextThreadIdx_ = new SynchronizedInt(0);
    ClockDaemon timeDaemon = new ClockDaemon();
    private final SynchronizedRef contention_ = new SynchronizedRef(null);
    private final SynchronizedInt loopsPerTest_ = new SynchronizedInt(0);
    private final SynchronizedBoolean echoToSystemOut = new SynchronizedBoolean(false);
    private final JButton startstop_ = new JButton("Start");
    private WaitableInt testNumber_ = new WaitableInt(1);
    private SynchronizedBoolean running_ = new SynchronizedBoolean(false);
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$Slot;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Times per call in microseconds");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SynchronizationTimer().mainPanel());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static String modeToString(int n) {
        String string = n == 0 ? "block" : (n == 1 ? "timeout" : "No such mode");
        return string;
    }

    static String biasToString(int n) {
        String string = n < 0 ? "slower producer" : (n == 0 ? "balanced prod/cons rate" : (n > 0 ? "slower consumer" : "No such bias"));
        return string;
    }

    static String p2ToString(int n) {
        String string = "";
        if (n >= 1024) {
            string = "K";
            if ((n /= 1024) >= 1024) {
                n /= 1024;
                string = "M";
            }
        }
        return n + string;
    }

    static String formatTime(long l, boolean bl) {
        long l2 = l / 10L;
        long l3 = l % 10L;
        if (!bl) {
            if (l3 >= 5L) {
                ++l2;
            }
            return Long.toString(l2);
        }
        String string = Long.toString(l2);
        String string2 = Long.toString(l3);
        if (l3 == 0L) {
            int n = 10;
            while (n > 10) {
                string2 = "0" + string2;
                n /= 10;
            }
        }
        String string3 = string + "." + string2;
        return string3;
    }

    boolean threadEnabled(int n) {
        return this.threadInfo[n].getEnabled();
    }

    JPanel resultPanel() {
        JComponent jComponent;
        int n;
        JPanel[] jPanelArray = new JPanel[this.tableColumns];
        int n2 = 0;
        while (n2 < this.tableColumns) {
            jPanelArray[n2] = new JPanel();
            jPanelArray[n2].setLayout(new GridLayout(this.tableRows, 1));
            if (n2 != 0) {
                jPanelArray[n2].setBackground(Color.white);
            }
            ++n2;
        }
        Color color = jPanelArray[0].getBackground();
        LineBorder lineBorder = new LineBorder(color);
        Font font = new Font("Dialog", 0, 12);
        Dimension dimension = new Dimension(40, 16);
        Dimension dimension2 = new Dimension(154, 16);
        JLabel jLabel = new JLabel(" Classes      \\      Threads");
        jLabel.setMinimumSize(dimension2);
        jLabel.setPreferredSize(dimension2);
        jLabel.setFont(font);
        this.resultTable_[0][0] = jLabel;
        jPanelArray[0].add(jLabel);
        int n3 = 1;
        while (n3 < this.tableColumns) {
            n = n3 - 1;
            jComponent = new JCheckBox(this.threadInfo[n].name, true);
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SynchronizationTimer.this.threadInfo[n].toggleEnabled();
                }
            });
            jComponent.setMinimumSize(dimension);
            jComponent.setPreferredSize(dimension);
            jComponent.setFont(font);
            jComponent.setBackground(color);
            this.resultTable_[0][n3] = jComponent;
            jPanelArray[n3].add(jComponent);
            ++n3;
        }
        n = 1;
        while (n < this.tableRows) {
            final int n4 = n - 1;
            JCheckBox jCheckBox = new JCheckBox(TestedClass.classes[n4].name, true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TestedClass.classes[n4].toggleEnabled();
                }
            });
            this.resultTable_[n][0] = jCheckBox;
            jCheckBox.setMinimumSize(dimension2);
            jCheckBox.setPreferredSize(dimension2);
            jCheckBox.setFont(font);
            jPanelArray[0].add(jCheckBox);
            int n5 = 1;
            while (n5 < this.tableColumns) {
                int n6 = n5 - 1;
                JLabel jLabel2 = new JLabel("");
                this.resultTable_[n][n5] = jLabel2;
                jLabel2.setMinimumSize(dimension);
                jLabel2.setPreferredSize(dimension);
                jLabel2.setBorder(lineBorder);
                jLabel2.setFont(font);
                jLabel2.setBackground(Color.white);
                jLabel2.setForeground(Color.black);
                jLabel2.setHorizontalAlignment(4);
                jPanelArray[n5].add(jLabel2);
                ++n5;
            }
            ++n;
        }
        jComponent = new JPanel();
        jComponent.setLayout(new BoxLayout(jComponent, 0));
        int n7 = 0;
        while (n7 < this.tableColumns) {
            jComponent.add(jPanelArray[n7]);
            ++n7;
        }
        return jComponent;
    }

    void setTime(final long l, int n, int n2) {
        int n3 = n + 1;
        int n4 = n2 + 1;
        final JLabel jLabel = (JLabel)this.resultTable_[n3][n4];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jLabel.setText(SynchronizationTimer.formatTime(l, true));
            }
        });
    }

    void clearTable() {
        int n = 1;
        while (n < this.tableRows) {
            int n2 = 1;
            while (n2 < this.tableColumns) {
                ((JLabel)this.resultTable_[n][n2]).setText("");
                ++n2;
            }
            ++n;
        }
    }

    void setChecks(boolean bl) {
        int n = 0;
        while (n < TestedClass.classes.length) {
            TestedClass.classes[n].setEnabled(new Boolean(bl));
            ((JCheckBox)this.resultTable_[n + 1][0]).setSelected(bl);
            ++n;
        }
    }

    public SynchronizationTimer() {
        int n = 0;
        while (n < this.threadInfo.length) {
            this.threadInfo[n] = new ThreadInfo(nthreadsChoices[n]);
            ++n;
        }
    }

    JPanel mainPanel() {
        new PrintStart();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3));
        this.startstop_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SynchronizationTimer.this.running_.get()) {
                    SynchronizationTimer.this.cancel();
                } else {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries());
                    }
                    catch (InterruptedException interruptedException) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        jPanel.add(this.startstop_);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("Continue");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                block2: {
                    if (SynchronizationTimer.this.running_.get()) break block2;
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries(SynchronizationTimer.this.nextClassIdx_.get(), SynchronizationTimer.this.nextThreadIdx_.get()));
                    }
                    catch (InterruptedException interruptedException) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("Clear cells");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.clearTable();
            }
        });
        jPanel3.add(jButton2);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        JButton jButton3 = new JButton("All classes");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.setChecks(true);
            }
        });
        jPanel4.add(jButton3);
        JButton jButton4 = new JButton("No classes");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.setChecks(false);
            }
        });
        jPanel4.add(jButton4);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JCheckBox jCheckBox = new JCheckBox("Console echo");
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SynchronizationTimer.this.echoToSystemOut.complement();
            }
        });
        JLabel jLabel = new JLabel("Active threads:      0");
        jPanel5.add(jLabel);
        jPanel5.add(jCheckBox);
        jPanel.add(jPanel5);
        jPanel.add(this.contentionBox());
        jPanel.add(this.itersBox());
        jPanel.add(this.cloopBox());
        jPanel.add(this.barrierBox());
        jPanel.add(this.exchangeBox());
        jPanel.add(this.biasBox());
        jPanel.add(this.capacityBox());
        jPanel.add(this.timeoutBox());
        jPanel.add(this.syncModePanel());
        jPanel.add(this.producerSyncModePanel());
        jPanel.add(this.consumerSyncModePanel());
        this.startPoolStatus(jLabel);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JPanel jPanel7 = this.resultPanel();
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel);
        return jPanel6;
    }

    JComboBox syncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < syncModes.length) {
            String string = "Locks: " + SynchronizationTimer.modeToString(syncModes[n]);
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.syncMode.set(syncModes[n]);
            }
        });
        RNG.syncMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox producerSyncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < syncModes.length) {
            String string = "Producers: " + SynchronizationTimer.modeToString(syncModes[n]);
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.producerMode.set(syncModes[n]);
            }
        });
        RNG.producerMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox consumerSyncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < syncModes.length) {
            String string = "Consumers: " + SynchronizationTimer.modeToString(syncModes[n]);
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.consumerMode.set(syncModes[n]);
            }
        });
        RNG.consumerMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox contentionBox() {
        final Fraction[] fractionArray = new Fraction[]{new Fraction(0L, 1L), new Fraction(1L, 16L), new Fraction(1L, 8L), new Fraction(1L, 4L), new Fraction(1L, 2L), new Fraction(1L, 1L)};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < fractionArray.length) {
            String string = fractionArray[n].asDouble() * 100.0 + "% contention/sharing";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                SynchronizationTimer.this.contention_.set(fractionArray[n]);
            }
        });
        this.contention_.set(fractionArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox itersBox() {
        final int[] nArray = new int[]{1, 16, 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.p2ToString(nArray[n]) + " calls per thread per test";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                SynchronizationTimer.this.loopsPerTest_.set(nArray[n]);
            }
        });
        this.loopsPerTest_.set(nArray[8]);
        jComboBox.setSelectedIndex(8);
        return jComboBox;
    }

    JComboBox cloopBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.p2ToString(nArray[n]) + " computations per call";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.computeLoops.set(nArray[n]);
            }
        });
        RNG.computeLoops.set(nArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox barrierBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.p2ToString(nArray[n]) + " iterations per barrier";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.itersPerBarrier.set(nArray[n]);
            }
        });
        RNG.itersPerBarrier.set(nArray[13]);
        jComboBox.setSelectedIndex(13);
        return jComboBox;
    }

    JComboBox exchangeBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.p2ToString(nArray[n]) + " max threads per barrier";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.exchangeParties.set(nArray[n]);
            }
        });
        RNG.exchangeParties.set(nArray[1]);
        jComboBox.setSelectedIndex(1);
        return jComboBox;
    }

    JComboBox biasBox() {
        final int[] nArray = new int[]{-1, 0, 1};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.biasToString(nArray[n]);
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.bias.set(nArray[n]);
            }
        });
        RNG.bias.set(nArray[1]);
        jComboBox.setSelectedIndex(1);
        return jComboBox;
    }

    JComboBox capacityBox() {
        final int[] nArray = new int[]{1, 4, 64, 256, 1024, 4096, 16384, 65536, 262144, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.p2ToString(nArray[n]) + " element bounded buffers";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                DefaultChannelCapacity.set(nArray[n]);
            }
        });
        DefaultChannelCapacity.set(nArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox timeoutBox() {
        final long[] lArray = new long[]{0L, 1L, 10L, 100L, 1000L, 10000L, 100000L};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < lArray.length) {
            String string = lArray[n] + " msec timeouts";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.timeout.set(lArray[n]);
            }
        });
        RNG.timeout.set(lArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    void startPoolStatus(final JLabel jLabel) {
        Runnable runnable = new Runnable(){
            int lastps = 0;

            public void run() {
                int n = Threads.activeThreads.get();
                if (this.lastps != n) {
                    this.lastps = n;
                    SwingUtilities.invokeLater(new Runnable(this, n){
                        private final /* synthetic */ int val$ps;
                        private final /* synthetic */ 22 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$ps = n;
                        }

                        public void run() {
                            22.access$400(this.this$1).setText("Active threads: " + this.val$ps);
                        }
                    });
                }
            }

            static /* synthetic */ JLabel access$400(22 var0) {
                return var0.jLabel;
            }
        };
        this.timeDaemon.executePeriodically(250L, runnable, false);
    }

    private void runOneTest(Runnable runnable) throws InterruptedException {
        int n = this.testNumber_.get();
        Threads.pool.execute(runnable);
        this.testNumber_.whenNotEqual(n, null);
    }

    private void endOneTest() {
        this.testNumber_.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Object object = RNG.constructionLock;
        synchronized (object) {
            try {
                Threads.pool.interruptAll();
            }
            catch (Exception exception) {
                System.out.println("\nException during cancel:\n" + exception);
                return;
            }
        }
    }

    void startTestSeries(Runnable runnable) throws InterruptedException {
        this.running_.set(true);
        this.startstop_.setText("Stop");
        Threads.pool.execute(runnable);
    }

    void endTestSeries() {
        this.running_.set(false);
        SwingUtilities.invokeLater(new PrintStart());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$700(SynchronizationTimer synchronizationTimer) {
        synchronizationTimer.endOneTest();
    }

    class OneTest
    implements Runnable {
        final int clsIdx;
        final int nthreadsIdx;

        OneTest(int n, int n2) {
            this.clsIdx = n;
            this.nthreadsIdx = n2;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    static class BarrierTimer
    implements Runnable {
        private long startTime_ = 0L;
        private long endTime_ = 0L;

        BarrierTimer() {
        }

        public synchronized long getTime() {
            return this.endTime_ - this.startTime_;
        }

        public synchronized void run() {
            long l = System.currentTimeMillis();
            if (this.startTime_ == 0L) {
                this.startTime_ = l;
            } else {
                this.endTime_ = l;
            }
        }
    }

    class TestSeries
    implements Runnable {
        final int firstclass;
        final int firstnthreads;

        TestSeries() {
            this.firstclass = 0;
            this.firstnthreads = 0;
        }

        TestSeries(int n, int n2) {
            this.firstclass = n;
            this.firstnthreads = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread.currentThread().setPriority(5);
            try {
                try {
                    int n = this.firstnthreads;
                    int n2 = this.firstclass;
                    if (n < nthreadsChoices.length && n2 < TestedClass.classes.length) {
                        while (true) {
                            if (SynchronizationTimer.this.threadEnabled(n)) {
                                TestedClass testedClass = TestedClass.classes[n2];
                                int n3 = nthreadsChoices[n];
                                int n4 = SynchronizationTimer.this.loopsPerTest_.get();
                                Fraction fraction = (Fraction)SynchronizationTimer.this.contention_.get();
                                if (testedClass.isEnabled(n3, fraction)) {
                                    SynchronizationTimer.this.runOneTest(new OneTest(n2, n));
                                }
                            }
                            if (++n2 >= TestedClass.classes.length) {
                                n2 = 0;
                                if (++n >= nthreadsChoices.length) break;
                            }
                            SynchronizationTimer.this.nextClassIdx_.set(n2);
                            SynchronizationTimer.this.nextThreadIdx_.set(n);
                        }
                    }
                    Object var8_8 = null;
                    SynchronizationTimer.this.endTestSeries();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    Object var8_9 = null;
                    SynchronizationTimer.this.endTestSeries();
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                SynchronizationTimer.this.endTestSeries();
                throw throwable;
            }
        }
    }

    class PrintStart
    implements Runnable {
        PrintStart() {
        }

        public void run() {
            SynchronizationTimer.this.startstop_.setText("Start");
        }
    }

    static class ThreadInfo {
        final String name;
        final int number;
        Boolean enabled;

        ThreadInfo(int n) {
            this.number = n;
            this.name = SynchronizationTimer.p2ToString(n);
            this.enabled = new Boolean(true);
        }

        synchronized Boolean getEnabled() {
            return this.enabled;
        }

        synchronized void setEnabled(Boolean bl) {
            this.enabled = bl;
        }

        synchronized void toggleEnabled() {
            this.enabled = new Boolean(this.enabled == false);
        }
    }

    static class TestedClass {
        final String name;
        final Class cls;
        final boolean multipleOK;
        final boolean singleOK;
        final Class buffCls;
        Boolean enabled_ = new Boolean(true);
        static final TestedClass dummy = new TestedClass("", null, false, false);
        static final TestedClass[] classes = new TestedClass[]{new TestedClass("NoSynchronization", class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.NoSynchRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG, false, true), new TestedClass("PublicSynchronization", class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PublicSynchRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG, true, true), new TestedClass("NestedSynchronization", class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.AllSynchRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG, true, true), new TestedClass("SDelegated", class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SDelegatedRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG, true, true), new TestedClass("SynchLongUsingSet", class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SynchLongRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG, true, true), new TestedClass("SynchLongUsingCommit", class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.AClongRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG, true, true), new TestedClass("Semaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG, true, true), new TestedClass("WaiterPrefSemaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.WpSemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG, true, true), new TestedClass("FIFOSemaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.FifoRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG, true, true), new TestedClass("PrioritySemaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PrioritySemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG, true, true), new TestedClass("Mutex", class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.MutexRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG, true, true), new TestedClass("ReentrantLock", class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.RlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG, true, true), new TestedClass("WriterPrefRWLock", class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.WpRWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG, true, true), new TestedClass("ReaderPrefRWLock", class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ReaderPrefRWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG, true, true), new TestedClass("FIFORWLock", class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.FIFORWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG, true, true), new TestedClass("ReentrantRWL", class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ReentrantRWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG, true, true), new TestedClass("LinkedQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.LinkedQueue")) : class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue), new TestedClass("WaitFreeQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue")) : class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue), new TestedClass("BoundedLinkedQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue")) : class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue), new TestedClass("BoundedBuffer", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer == null ? (class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedBuffer")) : class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer), new TestedClass("CondVarBoundedBuffer", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.CVBuffer")) : class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer), new TestedClass("BoundedPriorityQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue")) : class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue), new TestedClass("Slot", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$Slot == null ? (class$EDU$oswego$cs$dl$util$concurrent$Slot = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.Slot")) : class$EDU$oswego$cs$dl$util$concurrent$Slot), new TestedClass("SynchronousChannel", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, false, class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel == null ? (class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.SynchronousChannel")) : class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel), new TestedClass("DirectExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.DirectExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG, true, true), new TestedClass("SemaphoreLckExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.LockedSemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG, true, true), new TestedClass("QueuedExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.QueuedExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG, true, true), new TestedClass("ThreadedExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ThreadedExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG, true, true), new TestedClass("PooledExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PooledExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG, true, true)};

        synchronized void setEnabled(Boolean bl) {
            this.enabled_ = bl;
        }

        synchronized Boolean getEnabled() {
            return this.enabled_;
        }

        synchronized void toggleEnabled() {
            boolean bl = this.enabled_;
            this.enabled_ = new Boolean(!bl);
        }

        synchronized boolean isEnabled(int n, Fraction fraction) {
            boolean bl = this.enabled_;
            if (!bl) {
                return false;
            }
            if (!this.singleOK && n <= 1) {
                return false;
            }
            return this.multipleOK || n <= 1 || fraction.compareTo(0L) <= 0;
        }

        TestedClass(String string, Class clazz, boolean bl, boolean bl2) {
            this.name = string;
            this.cls = clazz;
            this.multipleOK = bl;
            this.singleOK = bl2;
            this.buffCls = null;
        }

        TestedClass(String string, Class clazz, boolean bl, boolean bl2, Class clazz2) {
            this.name = string;
            this.cls = clazz;
            this.multipleOK = bl;
            this.singleOK = bl2;
            this.buffCls = clazz2;
        }
    }
}

