/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing.tools.wsdl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaAddressingServiceImplWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaAddressingServiceImplWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName() + "AddressingLocator", "service");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends " + this.sEntry.getName() + "Locator ";
    }

    protected String getImplementsText() {
        return "implements " + this.sEntry.getName() + "Addressing ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Service service = this.sEntry.getService();
        Map portMap = service.getPorts();
        Iterator portIterator = portMap.values().iterator();
        while (portIterator.hasNext()) {
            Port p = (Port)portIterator.next();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage("emitFailNoBinding01", new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoBindingEntry01", new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(Messages.getMessage("emitFailNoPortType01", new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bEntry.getBindingType() != 0) continue;
            String portName = p.getName();
            if (!JavaUtils.isJavaId(portName)) {
                portName = Utils.xmlNameToJavaClass(portName);
            }
            String stubClass = bEntry.getName() + "Stub";
            String bindingType = (String)bEntry.getDynamicVar(JavaBindingWriter.INTERFACE_NAME);
            pw.println("    public " + bindingType + " get" + portName + "(org.apache.axis.message.addressing.EndpointReferenceType reference) " + "throws javax.xml.rpc.ServiceException {");
            pw.println("\torg.apache.axis.message.addressing.AttributedURI address = reference.getAddress();");
            pw.println("\tif (address == null) {");
            pw.println("\t\tthrow new javax.xml.rpc.ServiceException(\"No address in EndpointReference\");");
            pw.println("\t}");
            pw.println("\tjava.net.URL endpoint;");
            pw.println("\ttry {");
            pw.println("\t\tendpoint = new java.net.URL(address.toString());");
            pw.println("\t} catch (java.net.MalformedURLException e) {");
            pw.println("\t\tthrow new javax.xml.rpc.ServiceException(e);");
            pw.println("\t}");
            pw.println("\t" + bindingType + " _stub = " + "get" + portName + "(endpoint);");
            pw.println("\tif (_stub != null) {");
            pw.println("\t\torg.apache.axis.message.addressing.AddressingHeaders headers =");
            pw.println("\t\t\tnew org.apache.axis.message.addressing.AddressingHeaders();");
            pw.println("\t\theaders.setTo(address);");
            pw.println("\t\theaders.setReferenceProperties(reference.getProperties());");
            pw.println("\t\t((javax.xml.rpc.Stub)_stub)._setProperty(org.apache.axis.message.addressing.Constants.ENV_ADDRESSING_SHARED_HEADERS, headers);");
            pw.println("\t}");
            pw.println("\treturn _stub;");
            pw.println("    }");
            pw.println();
        }
        pw.println();
    }
}

